/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.bookmarks;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkHolder;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.tree.TreeState;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.commons.internal.memento._Mementos;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class BookmarkServiceInternalDefault
implements BookmarkService,
_Mementos.SerializingAdapter {
    private Map<String, Object> servicesByClassName;
    private static final Set<Class<? extends Serializable>> serializableFinalTypes = _Sets.of((Object[])new Class[]{String.class, String[].class, Class.class, Class[].class, Boolean.class, Boolean.TYPE, Boolean[].class, boolean[].class, Byte.class, Byte.TYPE, Byte[].class, byte[].class, Short.class, Short.TYPE, Short[].class, short[].class, Integer.class, Integer.TYPE, Integer[].class, int[].class, Long.class, Long.TYPE, Long[].class, long[].class, Float.class, Float.TYPE, Float[].class, float[].class, Double.class, Double.TYPE, Double[].class, double[].class});
    private static final List<Class<? extends Serializable>> serializableTypes = _Lists.of((Object[])new Class[]{BigDecimal.class, BigInteger.class, java.util.Date.class, Date.class, Enum.class, Bookmark.class, TreeState.class});
    @Inject
    PersistenceSessionServiceInternal persistenceSessionServiceInternal;
    @Inject
    WrapperFactory wrapperFactory;
    @Inject
    ServiceRegistry serviceRegistry;

    @Programmatic
    public Object lookup(BookmarkHolder bookmarkHolder, BookmarkService.FieldResetPolicy fieldResetPolicy) {
        Bookmark bookmark = bookmarkHolder.bookmark();
        return bookmark != null ? this.lookup(bookmark, fieldResetPolicy) : null;
    }

    private Object lookupInternal(Bookmark bookmark, BookmarkService.FieldResetPolicy fieldResetPolicy) {
        if (bookmark == null) {
            return null;
        }
        try {
            return this.persistenceSessionServiceInternal.lookup(bookmark, fieldResetPolicy);
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
    }

    @Programmatic
    public Object lookup(Bookmark bookmark, BookmarkService.FieldResetPolicy fieldResetPolicy) {
        if (bookmark == null) {
            return null;
        }
        String objectType = bookmark.getObjectType();
        Object service = this.lookupService(objectType);
        if (service != null) {
            return service;
        }
        return this.lookupInternal(bookmark, fieldResetPolicy);
    }

    @Programmatic
    public <T> T lookup(Bookmark bookmark, BookmarkService.FieldResetPolicy fieldResetPolicy, Class<T> cls) {
        return (T)this.lookup(bookmark, fieldResetPolicy);
    }

    @Programmatic
    public Bookmark bookmarkFor(Object domainObject) {
        if (domainObject == null) {
            return null;
        }
        return this.persistenceSessionServiceInternal.bookmarkFor(this.unwrapped(domainObject));
    }

    private Object unwrapped(Object domainObject) {
        return this.wrapperFactory != null ? this.wrapperFactory.unwrap(domainObject) : domainObject;
    }

    @Programmatic
    public Bookmark bookmarkFor(Class<?> cls, String identifier) {
        return this.persistenceSessionServiceInternal.bookmarkFor(cls, identifier);
    }

    private Object lookupService(String className) {
        this.cacheServicesByClassNameIfNecessary();
        return this.servicesByClassName.get(className);
    }

    private void cacheServicesByClassNameIfNecessary() {
        if (this.servicesByClassName == null) {
            HashMap servicesByClassName = _Maps.newHashMap();
            Stream registeredServices = this.serviceRegistry.streamServices();
            registeredServices.forEach(registeredService -> {
                String serviceClassName = registeredService.getClass().getName();
                servicesByClassName.put(serviceClassName, registeredService);
            });
            this.servicesByClassName = servicesByClassName;
        }
    }

    public <T> T read(Class<T> cls, Serializable value) {
        if (Bookmark.class.equals(cls)) {
            return (T)_Casts.uncheckedCast((Object)value);
        }
        if (Bookmark.class.isAssignableFrom(value.getClass())) {
            Bookmark valueBookmark = (Bookmark)value;
            return (T)_Casts.uncheckedCast((Object)this.lookup(valueBookmark, BookmarkService.FieldResetPolicy.RESET));
        }
        return (T)_Casts.uncheckedCast((Object)value);
    }

    public Serializable write(Object value) {
        if (BookmarkServiceInternalDefault.isPredefinedSerializable(value.getClass())) {
            return (Serializable)value;
        }
        Bookmark valueBookmark = this.bookmarkFor(value);
        return valueBookmark;
    }

    private static boolean isPredefinedSerializable(Class<?> cls) {
        if (!Serializable.class.isAssignableFrom(cls)) {
            return false;
        }
        if (cls.getName().startsWith("java.time.")) {
            return true;
        }
        if (cls.getName().startsWith("org.joda.time.")) {
            return true;
        }
        if (serializableFinalTypes.contains(cls)) {
            return true;
        }
        return serializableTypes.stream().anyMatch(t -> t.isAssignableFrom(cls));
    }
}

