/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.appfeat;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.services.appfeat.ApplicationMemberType;
import org.apache.isis.applib.util.Equality;
import org.apache.isis.applib.util.Hashing;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.applib.util.TitleBuffer;
import org.apache.isis.applib.util.ToString;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeature;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureRepositoryDefault;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureType;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;

@Value
public class ApplicationFeatureId
implements Comparable<ApplicationFeatureId>,
Serializable {
    private static final long serialVersionUID = 1L;
    ApplicationFeatureType type;
    private String packageName;
    private String className;
    private String memberName;
    private static final Comparator<ApplicationFeatureId> byType = Comparator.comparing(ApplicationFeatureId::getType, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final Comparator<ApplicationFeatureId> byPackageName = Comparator.comparing(ApplicationFeatureId::getPackageName, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final Comparator<ApplicationFeatureId> byClassName = Comparator.comparing(ApplicationFeatureId::getClassName, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final Comparator<ApplicationFeatureId> byMemberName = Comparator.comparing(ApplicationFeatureId::getMemberName, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final Comparator<ApplicationFeatureId> applicationFeatureIdOrdering = Comparator.nullsFirst(byType).thenComparing(byPackageName).thenComparing(byClassName).thenComparing(byMemberName);
    private static final Equality<ApplicationFeatureId> equality = ObjectContracts.checkEquals(ApplicationFeatureId::getType).thenCheckEquals(ApplicationFeatureId::getPackageName).thenCheckEquals(ApplicationFeatureId::getClassName).thenCheckEquals(ApplicationFeatureId::getMemberName);
    private static final Hashing<ApplicationFeatureId> hashing = ObjectContracts.hashing(ApplicationFeatureId::getType).thenHashing(ApplicationFeatureId::getPackageName).thenHashing(ApplicationFeatureId::getClassName).thenHashing(ApplicationFeatureId::getMemberName);
    private static final ToString<ApplicationFeatureId> toString = ObjectContracts.toString((String)"type", ApplicationFeatureId::getType).thenToString("packageName", ApplicationFeatureId::getPackageName).thenToStringOmmitIfAbsent("className", ApplicationFeatureId::getClassName).thenToStringOmmitIfAbsent("memberName", ApplicationFeatureId::getMemberName);

    public static ApplicationFeatureId newFeature(ApplicationFeatureType featureType, String fullyQualifiedName) {
        switch (featureType) {
            case PACKAGE: {
                return ApplicationFeatureId.newPackage(fullyQualifiedName);
            }
            case CLASS: {
                return ApplicationFeatureId.newClass(fullyQualifiedName);
            }
            case MEMBER: {
                return ApplicationFeatureId.newMember(fullyQualifiedName);
            }
        }
        throw new IllegalArgumentException("Unknown feature type " + (Object)((Object)featureType));
    }

    public static ApplicationFeatureId newFeature(String packageFqn, String className, String memberName) {
        if (className == null) {
            return ApplicationFeatureId.newPackage(packageFqn);
        }
        String classFqn = packageFqn + "." + className;
        if (memberName == null) {
            return ApplicationFeatureId.newClass(classFqn);
        }
        return ApplicationFeatureId.newMember(classFqn, memberName);
    }

    public static ApplicationFeatureId newPackage(String packageFqn) {
        ApplicationFeatureId featureId = new ApplicationFeatureId(ApplicationFeatureType.PACKAGE);
        featureId.setPackageName(packageFqn);
        return featureId;
    }

    public static ApplicationFeatureId newClass(String classFqn) {
        ApplicationFeatureId featureId = new ApplicationFeatureId(ApplicationFeatureType.CLASS);
        featureId.type.init(featureId, classFqn);
        return featureId;
    }

    public static ApplicationFeatureId newMember(String classFqn, String memberName) {
        ApplicationFeatureId featureId = new ApplicationFeatureId(ApplicationFeatureType.MEMBER);
        ApplicationFeatureType.CLASS.init(featureId, classFqn);
        featureId.type = ApplicationFeatureType.MEMBER;
        featureId.setMemberName(memberName);
        return featureId;
    }

    public static ApplicationFeatureId newMember(String fullyQualifiedName) {
        ApplicationFeatureId featureId = new ApplicationFeatureId(ApplicationFeatureType.MEMBER);
        featureId.type.init(featureId, fullyQualifiedName);
        return featureId;
    }

    public static ApplicationFeatureId parse(String asString) {
        return new ApplicationFeatureId(asString);
    }

    public static ApplicationFeatureId parseEncoded(String encodedString) {
        return new ApplicationFeatureId(ApplicationFeatureId.base64UrlDecode(encodedString));
    }

    private ApplicationFeatureId(String asString) {
        Iterator iterator = _Strings.splitThenStream((String)asString, (String)":").iterator();
        ApplicationFeatureType type = ApplicationFeatureType.valueOf((String)iterator.next());
        type.init(this, (String)iterator.next());
    }

    ApplicationFeatureId(ApplicationFeatureType type) {
        this.type = type;
    }

    public ApplicationFeatureId(ApplicationFeatureType type, String fullyQualifiedName) {
        type.init(this, fullyQualifiedName);
    }

    public String title() {
        TitleBuffer buf = new TitleBuffer();
        buf.append(this.getFullyQualifiedName());
        return buf.toString();
    }

    @Programmatic
    public String getFullyQualifiedName() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getPackageName());
        if (this.getClassName() != null) {
            buf.append(".").append(this.getClassName());
        }
        if (this.getMemberName() != null) {
            buf.append("#").append(this.getMemberName());
        }
        return buf.toString();
    }

    @Programmatic
    public ObjectSpecId getObjectSpecId() {
        if (this.getClassName() == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (!_Strings.isNullOrEmpty((CharSequence)this.getPackageName())) {
            buf.append(this.getPackageName()).append(".");
        }
        buf.append(this.getClassName());
        return ObjectSpecId.of(buf.toString());
    }

    public ApplicationFeatureType getType() {
        return this.type;
    }

    @Programmatic
    public String getPackageName() {
        return this.packageName;
    }

    void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Programmatic
    public String getClassName() {
        return this.className;
    }

    void setClassName(String className) {
        this.className = className;
    }

    @Programmatic
    public String getMemberName() {
        return this.memberName;
    }

    void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    @Programmatic
    public ApplicationFeatureId getParentPackageId() {
        ApplicationFeatureType.ensurePackageOrClass(this);
        if (this.type == ApplicationFeatureType.CLASS) {
            return ApplicationFeatureId.newPackage(this.getPackageName());
        }
        String packageName = this.getPackageName();
        if (!packageName.contains(".")) {
            return null;
        }
        int cutOffPos = packageName.lastIndexOf(46);
        String parentPackageName = packageName.substring(0, cutOffPos);
        return ApplicationFeatureId.newPackage(parentPackageName);
    }

    public ApplicationFeatureId getParentClassId() {
        ApplicationFeatureType.ensureMember(this);
        String classFqn = this.getPackageName() + "." + this.getClassName();
        return ApplicationFeatureId.newClass(classFqn);
    }

    @Programmatic
    public String asString() {
        return this.type.name() + ":" + this.getFullyQualifiedName();
    }

    @Programmatic
    public String asEncodedString() {
        return ApplicationFeatureId.base64UrlEncode(this.asString());
    }

    private static String base64UrlDecode(String str) {
        return _Strings.convert((String)str, (_Bytes.BytesOperator)_Bytes.ofUrlBase64, (Charset)StandardCharsets.UTF_8);
    }

    private static String base64UrlEncode(String str) {
        return _Strings.convert((String)str, (_Bytes.BytesOperator)_Bytes.asUrlBase64, (Charset)StandardCharsets.UTF_8);
    }

    @Programmatic
    public List<ApplicationFeatureId> getPathIds() {
        return ApplicationFeatureId.pathIds(this);
    }

    @Programmatic
    public List<ApplicationFeatureId> getParentIds() {
        return ApplicationFeatureId.pathIds(this.getParentId());
    }

    private ApplicationFeatureId getParentId() {
        return this.type == ApplicationFeatureType.MEMBER ? this.getParentClassId() : this.getParentPackageId();
    }

    private static List<ApplicationFeatureId> pathIds(ApplicationFeatureId id) {
        ArrayList featureIds = _Lists.newArrayList();
        return Collections.unmodifiableList(ApplicationFeatureId.appendParents(id, featureIds));
    }

    private static List<ApplicationFeatureId> appendParents(ApplicationFeatureId featureId, List<ApplicationFeatureId> parentIds) {
        if (featureId != null) {
            parentIds.add(featureId);
            ApplicationFeatureId.appendParents(featureId.getParentId(), parentIds);
        }
        return parentIds;
    }

    @Override
    public int compareTo(ApplicationFeatureId other) {
        return applicationFeatureIdOrdering.compare(this, other);
    }

    public boolean equals(Object o) {
        return equality.equals((Object)this, o);
    }

    public int hashCode() {
        return hashing.hashCode((Object)this);
    }

    public String toString() {
        return toString.toString((Object)this);
    }

    public static final class Comparators {
        private Comparators() {
        }

        public static Comparator<ApplicationFeatureId> natural() {
            return new ApplicationFeatureIdComparator();
        }

        static class ApplicationFeatureIdComparator
        implements Comparator<ApplicationFeatureId>,
        Serializable {
            private static final long serialVersionUID = 1L;

            ApplicationFeatureIdComparator() {
            }

            @Override
            public int compare(ApplicationFeatureId o1, ApplicationFeatureId o2) {
                return o1.compareTo(o2);
            }
        }
    }

    public static class Predicates {
        private Predicates() {
        }

        public static Predicate<ApplicationFeatureId> isClassContaining(final ApplicationMemberType memberType, final ApplicationFeatureRepositoryDefault applicationFeatures) {
            return new Predicate<ApplicationFeatureId>(){

                @Override
                public boolean test(ApplicationFeatureId input) {
                    if (input.getType() != ApplicationFeatureType.CLASS) {
                        return false;
                    }
                    ApplicationFeature feature = applicationFeatures.findFeature(input);
                    if (feature == null) {
                        return false;
                    }
                    return memberType == null || !feature.membersOf(memberType).isEmpty();
                }
            };
        }

        public static Predicate<ApplicationFeatureId> isClassRecursivelyWithin(ApplicationFeatureId packageId) {
            return input -> input.getParentIds().contains(packageId);
        }
    }

    public static class Functions {
        public static final Function<ApplicationFeatureId, String> GET_CLASS_NAME = ApplicationFeatureId::getClassName;
        public static final Function<ApplicationFeatureId, String> GET_MEMBER_NAME = ApplicationFeatureId::getMemberName;

        private Functions() {
        }
    }
}

