/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.appfeat;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.appfeat.ApplicationMemberType;
import org.apache.isis.applib.util.Equality;
import org.apache.isis.applib.util.Hashing;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.applib.util.ToString;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureId;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureRepositoryDefault;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureType;

public class ApplicationFeature
implements Comparable<ApplicationFeature> {
    public static final int TYPICAL_LENGTH_PKG_FQN = 50;
    public static final int TYPICAL_LENGTH_CLS_NAME = 50;
    public static final int TYPICAL_LENGTH_MEMBER_NAME = 50;
    private ApplicationFeatureId featureId;
    private ApplicationMemberType memberType;
    private String returnTypeName;
    private boolean contributed;
    private Boolean derived;
    private Integer propertyMaxLength;
    private Integer propertyTypicalLength;
    private SemanticsOf actionSemantics;
    private final SortedSet<ApplicationFeatureId> contents = _Sets.newTreeSet();
    private final SortedSet<ApplicationFeatureId> properties = _Sets.newTreeSet();
    private final SortedSet<ApplicationFeatureId> collections = _Sets.newTreeSet();
    private final SortedSet<ApplicationFeatureId> actions = _Sets.newTreeSet();
    private static final Comparator<ApplicationFeature> comparator = Comparator.comparing(ApplicationFeature::getFeatureId);
    private static final Equality<ApplicationFeature> equality = ObjectContracts.checkEquals(ApplicationFeature::getFeatureId);
    private static final Hashing<ApplicationFeature> hashing = ObjectContracts.hashing(ApplicationFeature::getFeatureId);
    private static final ToString<ApplicationFeature> toString = ObjectContracts.toString((String)"featureId", ApplicationFeature::getFeatureId);

    public ApplicationFeature() {
        this(null);
    }

    public ApplicationFeature(ApplicationFeatureId featureId) {
        this.setFeatureId(featureId);
    }

    @Programmatic
    public ApplicationFeatureId getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(ApplicationFeatureId applicationFeatureId) {
        this.featureId = applicationFeatureId;
    }

    @Programmatic
    public ApplicationMemberType getMemberType() {
        return this.memberType;
    }

    public void setMemberType(ApplicationMemberType memberType) {
        this.memberType = memberType;
    }

    @Programmatic
    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    public void setReturnTypeName(String returnTypeName) {
        this.returnTypeName = returnTypeName;
    }

    @Programmatic
    public boolean isContributed() {
        return this.contributed;
    }

    public void setContributed(boolean contributed) {
        this.contributed = contributed;
    }

    @Programmatic
    public Boolean isDerived() {
        return this.derived;
    }

    public void setDerived(Boolean derived) {
        this.derived = derived;
    }

    @Programmatic
    public Integer getPropertyMaxLength() {
        return this.propertyMaxLength;
    }

    public void setPropertyMaxLength(Integer propertyMaxLength) {
        this.propertyMaxLength = propertyMaxLength;
    }

    @Programmatic
    public Integer getPropertyTypicalLength() {
        return this.propertyTypicalLength;
    }

    public void setPropertyTypicalLength(Integer propertyTypicalLength) {
        this.propertyTypicalLength = propertyTypicalLength;
    }

    @Programmatic
    public SemanticsOf getActionSemantics() {
        return this.actionSemantics;
    }

    public void setActionSemantics(SemanticsOf actionSemantics) {
        this.actionSemantics = actionSemantics;
    }

    @Programmatic
    public SortedSet<ApplicationFeatureId> getContents() {
        ApplicationFeatureType.ensurePackage(this.getFeatureId());
        return this.contents;
    }

    @Programmatic
    public void addToContents(ApplicationFeatureId contentId) {
        ApplicationFeatureType.ensurePackage(this.getFeatureId());
        ApplicationFeatureType.ensurePackageOrClass(contentId);
        this.contents.add(contentId);
    }

    @Programmatic
    public SortedSet<ApplicationFeatureId> getProperties() {
        ApplicationFeatureType.ensureClass(this.getFeatureId());
        return this.properties;
    }

    @Programmatic
    public SortedSet<ApplicationFeatureId> getCollections() {
        ApplicationFeatureType.ensureClass(this.getFeatureId());
        return this.collections;
    }

    @Programmatic
    public SortedSet<ApplicationFeatureId> getActions() {
        ApplicationFeatureType.ensureClass(this.getFeatureId());
        return this.actions;
    }

    @Programmatic
    public void addToMembers(ApplicationFeatureId memberId, ApplicationMemberType memberType) {
        ApplicationFeatureType.ensureClass(this.getFeatureId());
        ApplicationFeatureType.ensureMember(memberId);
        this.membersOf(memberType).add(memberId);
    }

    @Programmatic
    public SortedSet<ApplicationFeatureId> membersOf(ApplicationMemberType memberType) {
        ApplicationFeatureType.ensureClass(this.getFeatureId());
        switch (memberType) {
            case PROPERTY: {
                return this.properties;
            }
            case COLLECTION: {
                return this.collections;
            }
        }
        return this.actions;
    }

    @Override
    public int compareTo(ApplicationFeature other) {
        return comparator.compare(this, other);
    }

    public boolean equals(Object obj) {
        return equality.equals((Object)this, obj);
    }

    public int hashCode() {
        return hashing.hashCode((Object)this);
    }

    public String toString() {
        return toString.toString((Object)this);
    }

    public static class Predicates {
        private Predicates() {
        }

        public static Predicate<ApplicationFeature> packageContainingClasses(ApplicationMemberType memberType, ApplicationFeatureRepositoryDefault applicationFeatures) {
            return input -> input.getContents().stream().anyMatch(ApplicationFeatureId.Predicates.isClassContaining(memberType, applicationFeatures));
        }
    }

    public static class Functions {
        public static final Function<ApplicationFeature, String> GET_FQN = input -> input.getFeatureId().getFullyQualifiedName();

        private Functions() {
        }
    }

    public static abstract class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<ApplicationFeature> {
        private static final long serialVersionUID = 1L;
    }

    public static abstract class CollectionDomainEvent<T>
    extends IsisApplibModule.CollectionDomainEvent<ApplicationFeature, T> {
        private static final long serialVersionUID = 1L;
    }

    public static abstract class PropertyDomainEvent<T>
    extends IsisApplibModule.PropertyDomainEvent<ApplicationFeature, T> {
        private static final long serialVersionUID = 1L;
    }
}

