/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services;

import java.util.ArrayList;
import java.util.List;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.InjectorMethodEvaluator;
import org.apache.isis.core.metamodel.specloader.InjectorMethodEvaluatorDefault;

public class ServicesInjectorBuilder {
    private final List<Object> services = new ArrayList<Object>();
    private InjectorMethodEvaluator injectorMethodEvaluator;
    private boolean autowireSetters = false;
    private boolean autowireInject = false;

    public ServicesInjectorBuilder addService(Object service) {
        this.services.add(service);
        return this;
    }

    public ServicesInjectorBuilder addServices(List<Object> services) {
        this.services.addAll(services);
        return this;
    }

    public ServicesInjectorBuilder injectorMethodEvaluator(InjectorMethodEvaluator injectorMethodEvaluator) {
        this.injectorMethodEvaluator = injectorMethodEvaluator;
        return this;
    }

    public ServicesInjectorBuilder autowireSetters(boolean autowireSetters) {
        this.autowireSetters = autowireSetters;
        return this;
    }

    public ServicesInjectorBuilder autowireInject(boolean autowireInject) {
        this.autowireInject = autowireInject;
        return this;
    }

    public ServicesInjector build() {
        return new ServicesInjector(new ArrayList<Object>(this.services), (InjectorMethodEvaluator)_With.computeIfAbsent((Object)this.injectorMethodEvaluator, this::defaultInjectorMethodEvaluatorDefault), this.autowireSetters, this.autowireInject);
    }

    private InjectorMethodEvaluator defaultInjectorMethodEvaluatorDefault() {
        return new InjectorMethodEvaluatorDefault();
    }
}

