/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.cdi._CDI;
import org.apache.isis.commons.internal.collections._Collections;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.collections._Multimaps;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.metamodel.services.ServicesInjectorAware;
import org.apache.isis.core.metamodel.services.ServicesInjectorBuilder;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.InjectorMethodEvaluator;
import org.apache.isis.core.metamodel.specloader.InjectorMethodEvaluatorDefault;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.security.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.security.authentication.manager.AuthenticationManager;
import org.apache.isis.core.security.authorization.manager.AuthorizationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesInjector
implements ApplicationScopedComponent,
ServiceRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesInjector.class);
    private static final String KEY_SET_PREFIX = "isis.services.injector.setPrefix";
    private static final String KEY_INJECT_PREFIX = "isis.services.injector.injectPrefix";
    private final List<Object> services;
    private final _Multimaps.ListMultimap<Class<?>, Object> servicesAssignableToType = _Multimaps.newListMultimap();
    private final _Lazy<Map<Class<?>, Object>> serviceByConcreteType = _Lazy.of(this::initServiceByConcreteType);
    private final Map<Class<?>, Method[]> methodsByClassCache = _Maps.newHashMap();
    private final Map<Class<?>, Field[]> fieldsByClassCache = _Maps.newHashMap();
    private final InjectorMethodEvaluator injectorMethodEvaluator;
    private final boolean autowireSetters;
    private final boolean autowireInject;
    private AuthenticationManager authenticationManager;
    private AuthorizationManager authorizationManager;
    private SpecificationLoader specificationLoader;
    private AuthenticationSessionProvider authenticationSessionProvider;
    private PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    public static ServicesInjectorBuilder builder() {
        IsisConfiguration config = _Config.getConfiguration();
        return new ServicesInjectorBuilder().addService(config).autowireSetters(config.getBoolean(KEY_SET_PREFIX, true)).autowireInject(config.getBoolean(KEY_INJECT_PREFIX, true));
    }

    public static ServicesInjectorBuilder builderForTesting() {
        return ServicesInjector.builder().autowireSetters(true).autowireInject(false);
    }

    ServicesInjector(List<Object> services, InjectorMethodEvaluator injectorMethodEvaluator, boolean autowireSetters, boolean autowireInject) {
        this.services = new ArrayList<Object>(services);
        this.injectorMethodEvaluator = injectorMethodEvaluator != null ? injectorMethodEvaluator : new InjectorMethodEvaluatorDefault();
        this.autowireSetters = autowireSetters;
        this.autowireInject = autowireInject;
    }

    public boolean isRegisteredService(Class<?> cls) {
        return ((Map)this.serviceByConcreteType.get()).containsKey(cls);
    }

    public boolean isRegisteredServiceInstance(Object pojo) {
        if (pojo == null) {
            return false;
        }
        Class<?> key = pojo.getClass();
        Object serviceInstance = ((Map)this.serviceByConcreteType.get()).get(key);
        return Objects.equals(pojo, serviceInstance);
    }

    public <T> void addFallbackIfRequired(Class<T> serviceClass, T serviceInstance) {
        if (!ServicesInjector.contains(this.services, serviceClass)) {
            this.services.add(0, serviceInstance);
            this.serviceByConcreteType.clear();
        }
    }

    public void validateServices() {
        ServicesInjector.validate(this.streamServices());
    }

    private static void validate(Stream<Object> serviceInstances) {
        _Multimaps.ListMultimap servicesById = _Multimaps.newListMultimap();
        serviceInstances.forEach(serviceInstance -> {
            String id = ServiceUtil.idOfPojo(serviceInstance);
            servicesById.putElement((Object)id, serviceInstance);
        });
        String errorMsg = servicesById.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> {
            String serviceId = (String)entry.getKey();
            List duplicateServiceEntries = (List)entry.getValue();
            return String.format("serviceId '%s' is declared by domain services %s", serviceId, ServicesInjector.classNamesFor(duplicateServiceEntries));
        }).collect(Collectors.joining(", "));
        if (_Strings.isNotEmpty((CharSequence)errorMsg)) {
            throw new IllegalStateException("Service ids must be unique! " + errorMsg);
        }
    }

    private static String classNamesFor(Collection<Object> services) {
        return _NullSafe.stream(services).map(Object::getClass).map(Class::getName).collect(Collectors.joining(", "));
    }

    static boolean contains(List<Object> services, Class<?> serviceClass) {
        return _NullSafe.stream(services).anyMatch(ServicesInjector.isOfType(serviceClass));
    }

    public Stream<Class<?>> streamServiceTypes() {
        return ((Map)this.serviceByConcreteType.get()).keySet().stream();
    }

    public Stream<Object> streamServices() {
        return this.services.stream();
    }

    public <T> T injectServicesInto(T object) {
        this.injectServices(object, this.services);
        return object;
    }

    public void injectServicesInto(List<Object> objects) {
        for (Object object : objects) {
            this.injectInto(object);
            this.injectServicesInto(object);
        }
    }

    public void injectInto(Object candidate) {
        if (ServicesInjectorAware.class.isAssignableFrom(candidate.getClass())) {
            ServicesInjectorAware cast = (ServicesInjectorAware)ServicesInjectorAware.class.cast(candidate);
            cast.setServicesInjector(this);
        }
    }

    @Programmatic
    public <T> Stream<T> streamServices(Class<T> serviceClass) {
        return ((List)this.servicesAssignableToType.computeIfAbsent(serviceClass, this::locateMatchingServices)).stream().map(x -> _Casts.uncheckedCast((Object)x));
    }

    private void injectServices(Object object, List<Object> services) {
        Class<?> cls = object.getClass();
        this.autowireViaFields(object, services, cls);
        if (this.autowireSetters) {
            this.autowireViaPrefixedMethods(object, services, cls, "set");
        }
        if (this.autowireInject) {
            this.autowireViaPrefixedMethods(object, services, cls, "inject");
        }
    }

    private void autowireViaFields(Object object, List<Object> services, Class<?> cls) {
        _NullSafe.stream((Object[])this.fieldsByClassCache.computeIfAbsent(cls, __ -> cls.getDeclaredFields())).filter(ServicesInjector.isAnnotatedForInjection()).forEach(field -> this.autowire(object, (Field)field, services));
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            this.autowireViaFields(object, services, superclass);
        }
    }

    private void autowire(Object object, Field field, List<Object> services) {
        Class<?> typeToBeInjected = field.getType();
        if (typeToBeInjected == null) {
            return;
        }
        Class elementType = _Collections.inferElementTypeIfAny((Field)field);
        if (elementType != null) {
            Class<?> collectionTypeToBeInjected = typeToBeInjected;
            Collection collectionOfServices = (Collection)_NullSafe.stream(services).filter(_NullSafe::isPresent).filter(ServicesInjector.isOfType(elementType)).collect(_Collections.toUnmodifiableOfType(collectionTypeToBeInjected));
            ServicesInjector.invokeInjectorField(field, object, collectionOfServices);
        }
        for (Object service : services) {
            Class<?> serviceClass = service.getClass();
            if (!typeToBeInjected.isAssignableFrom(serviceClass)) continue;
            ServicesInjector.invokeInjectorField(field, object, service);
            return;
        }
        _CDI.getManagedBean(typeToBeInjected, (List)_CDI.filterQualifiers((Annotation[])field.getAnnotations())).ifPresent(bean -> ServicesInjector.invokeInjectorField(field, object, bean));
    }

    private void autowireViaPrefixedMethods(Object object, List<Object> services, Class<?> cls, String prefix) {
        _NullSafe.stream((Object[])this.methodsByClassCache.computeIfAbsent(cls, __ -> cls.getMethods())).filter(ServicesInjector.nameStartsWith(prefix)).forEach(prefixedMethod -> this.autowire(object, (Method)prefixedMethod, services));
    }

    private void autowire(Object object, Method prefixedMethod, List<Object> services) {
        for (Object service : services) {
            Class<?> serviceClass = service.getClass();
            boolean isInjectorMethod = this.injectorMethodEvaluator.isInjectorMethodFor(prefixedMethod, serviceClass);
            if (!isInjectorMethod) continue;
            prefixedMethod.setAccessible(true);
            ServicesInjector.invokeInjectorMethod(prefixedMethod, object, service);
            return;
        }
    }

    private static void invokeMethod(Method method, Object target, Object[] parameters) {
        try {
            method.invoke(target, parameters);
        }
        catch (IllegalAccessException | SecurityException e) {
            throw new MetaModelException(String.format("Cannot access the %s method in %s", method.getName(), target.getClass().getName()));
        }
        catch (IllegalArgumentException e1) {
            throw new MetaModelException(e1);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new MetaModelException(targetException);
        }
    }

    private static void invokeInjectorField(Field field, Object target, Object parameter) {
        try {
            field.setAccessible(true);
            field.set(target, parameter);
        }
        catch (IllegalArgumentException e) {
            throw new MetaModelException(e);
        }
        catch (IllegalAccessException e) {
            throw new MetaModelException(String.format("Cannot access the %s field in %s", field.getName(), target.getClass().getName()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("injected {} into {}", parameter, (Object)new ToString(target));
        }
    }

    private static void invokeInjectorMethod(Method method, Object target, Object parameter) {
        Object[] parameters = new Object[]{parameter};
        ServicesInjector.invokeMethod(method, target, parameters);
        if (LOG.isDebugEnabled()) {
            LOG.debug("injected {} into {}", parameter, (Object)new ToString(target));
        }
    }

    @Programmatic
    public void autowire() {
        this.injectServicesInto(this.services);
    }

    private <T> List<Object> locateMatchingServices(Class<T> serviceClass) {
        List<Object> matchingServices = this.services.stream().filter(ServicesInjector.isOfType(serviceClass)).collect(Collectors.toList());
        return matchingServices;
    }

    private Map<Class<?>, Object> initServiceByConcreteType() {
        HashMap map = _Maps.newHashMap();
        for (Object service : this.services) {
            Class<?> concreteType = service.getClass();
            map.put(concreteType, service);
        }
        return map;
    }

    private static final Predicate<Object> isOfType(Class<?> cls) {
        return obj -> cls.isAssignableFrom(obj.getClass());
    }

    private static final Predicate<Method> nameStartsWith(String prefix) {
        return method -> method.getName().startsWith(prefix);
    }

    private static final Predicate<Field> isAnnotatedForInjection() {
        return field -> field.getAnnotation(Inject.class) != null;
    }

    @Programmatic
    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager != null ? this.authenticationManager : (this.authenticationManager = (AuthenticationManager)this.lookupServiceElseFail(AuthenticationManager.class));
    }

    @Programmatic
    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager != null ? this.authorizationManager : (this.authorizationManager = (AuthorizationManager)this.lookupServiceElseFail(AuthorizationManager.class));
    }

    @Programmatic
    public SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader != null ? this.specificationLoader : (this.specificationLoader = (SpecificationLoader)this.lookupServiceElseFail(SpecificationLoader.class));
    }

    @Programmatic
    public AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider != null ? this.authenticationSessionProvider : (this.authenticationSessionProvider = (AuthenticationSessionProvider)this.lookupServiceElseFail(AuthenticationSessionProvider.class));
    }

    @Programmatic
    public PersistenceSessionServiceInternal getPersistenceSessionServiceInternal() {
        return this.persistenceSessionServiceInternal != null ? this.persistenceSessionServiceInternal : (this.persistenceSessionServiceInternal = (PersistenceSessionServiceInternal)this.lookupServiceElseFail(PersistenceSessionServiceInternal.class));
    }
}

