/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.progmodel;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.builder.IsisConfigurationBuilder;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.progmodel.DeprecatedMarker;
import org.apache.isis.core.metamodel.progmodel.FacetFactorySet;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;

public abstract class ProgrammingModelAbstract
implements ProgrammingModel {
    private final List<FacetFactory> facetFactories = _Lists.newArrayList();
    private final List<Object> facetFactoryInstancesOrClasses = _Lists.newLinkedList();
    public static final String KEY_IGNORE_DEPRECATED = "isis.reflector.facets.ignoreDeprecated";
    protected final DeprecatedPolicy deprecatedPolicy;

    public ProgrammingModelAbstract(DeprecatedPolicy deprecatedPolicy) {
        this.deprecatedPolicy = deprecatedPolicy;
    }

    @Override
    public void init() {
        this.initializeIfRequired();
    }

    private void initializeIfRequired() {
        if (!this.facetFactories.isEmpty()) {
            return;
        }
        this.initialize();
    }

    private void initialize() {
        for (Object factoryInstanceOrClass : this.facetFactoryInstancesOrClasses) {
            FacetFactory facetFactory = ProgrammingModelAbstract.asFacetFactory(factoryInstanceOrClass);
            this.facetFactories.add(facetFactory);
        }
    }

    private static FacetFactory asFacetFactory(Object factoryInstanceOrClass) {
        if (factoryInstanceOrClass instanceof FacetFactory) {
            return (FacetFactory)factoryInstanceOrClass;
        }
        Class factoryClass = (Class)factoryInstanceOrClass;
        return (FacetFactory)InstanceUtil.createInstance(factoryClass, new Object[0]);
    }

    private void assertNotInitialized() {
        if (!this.facetFactories.isEmpty()) {
            throw new IllegalStateException("Programming model already initialized");
        }
    }

    @Override
    public final List<FacetFactory> getList() {
        this.initializeIfRequired();
        return Collections.unmodifiableList(this.facetFactories);
    }

    @Override
    public final void addFactory(Class<? extends FacetFactory> factoryClass) {
        this.addFactory(factoryClass, FacetFactorySet.Position.END);
    }

    @Override
    public final void addFactory(Class<? extends FacetFactory> factoryClass, FacetFactorySet.Position position) {
        this.addFactory((Object)factoryClass, position);
    }

    @Override
    public void addFactory(FacetFactory facetFactory) {
        this.addFactory(facetFactory, FacetFactorySet.Position.END);
    }

    @Override
    public void addFactory(FacetFactory facetFactory, FacetFactorySet.Position position) {
        this.addFactory((Object)facetFactory, position);
    }

    private void addFactory(Object facetFactoryInstanceOrClass, FacetFactorySet.Position position) {
        this.assertNotInitialized();
        if (this.deprecatedPolicy == DeprecatedPolicy.IGNORE && (facetFactoryInstanceOrClass instanceof FacetFactory ? facetFactoryInstanceOrClass instanceof DeprecatedMarker : facetFactoryInstanceOrClass instanceof Class && DeprecatedMarker.class.isAssignableFrom((Class)facetFactoryInstanceOrClass))) {
            return;
        }
        switch (position) {
            case BEGINNING: {
                this.facetFactoryInstancesOrClasses.add(0, facetFactoryInstanceOrClass);
                break;
            }
            case END: {
                this.facetFactoryInstancesOrClasses.add(facetFactoryInstanceOrClass);
            }
        }
    }

    @Override
    public final void removeFactory(Class<? extends FacetFactory> factoryClass) {
        this.assertNotInitialized();
        Iterator<Object> iterator = this.facetFactoryInstancesOrClasses.iterator();
        while (iterator.hasNext()) {
            Object factoryInstanceOrClass = iterator.next();
            if (factoryInstanceOrClass != factoryClass && !factoryClass.isAssignableFrom(factoryInstanceOrClass.getClass())) continue;
            iterator.remove();
        }
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        for (FacetFactory facetFactory : this.getList()) {
            if (!(facetFactory instanceof MetaModelValidatorRefiner)) continue;
            MetaModelValidatorRefiner metaModelValidatorRefiner = (MetaModelValidatorRefiner)((Object)facetFactory);
            metaModelValidatorRefiner.refineMetaModelValidator(metaModelValidator);
        }
    }

    public static enum DeprecatedPolicy {
        IGNORE,
        HONOUR;


        public static DeprecatedPolicy parse(IsisConfiguration configuration) {
            boolean ignoreDep = configuration.getBoolean(ProgrammingModelAbstract.KEY_IGNORE_DEPRECATED, false);
            return ignoreDep ? IGNORE : HONOUR;
        }

        public static DeprecatedPolicy parse(IsisConfigurationBuilder configuration) {
            boolean ignoreDep = configuration.peekAtBoolean(ProgrammingModelAbstract.KEY_IGNORE_DEPRECATED, false);
            return ignoreDep ? IGNORE : HONOUR;
        }
    }
}

