/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.interactions;

import javax.annotation.Nullable;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.services.wrapper.events.InteractionEvent;
import org.apache.isis.commons.internal.base._Tuples;
import org.apache.isis.core.metamodel.consent.InteractionContextType;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.spec.ManagedObject;

public abstract class InteractionContext<T extends InteractionEvent> {
    private final InteractionContextType interactionType;
    private final Identifier identifier;
    private final InteractionInitiatedBy interactionInitiatedBy;
    private final ManagedObject target;
    private int contributeeParam = -1;
    private ManagedObject contributee = null;
    private ManagedObject mixedInAdapter = null;

    public InteractionContext(InteractionContextType interactionType, InteractionInitiatedBy invocationMethod, Identifier identifier, ManagedObject target) {
        this.interactionType = interactionType;
        this.interactionInitiatedBy = invocationMethod;
        this.identifier = identifier;
        this.target = target;
    }

    public InteractionContextType getInteractionType() {
        return this.interactionType;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public InteractionInitiatedBy getInitiatedBy() {
        return this.interactionInitiatedBy;
    }

    public boolean isFrameworkInitiated() {
        return this.interactionInitiatedBy == InteractionInitiatedBy.FRAMEWORK;
    }

    public ManagedObject getTarget() {
        return this.target;
    }

    public void putContributee(int contributeeParam, ManagedObject contributee) {
        this.contributeeParam = contributeeParam;
        this.contributee = contributee;
    }

    @Nullable
    public _Tuples.Tuple2<Integer, ManagedObject> getContributeeWithParamIndex() {
        if (this.contributee == null) {
            return null;
        }
        return _Tuples.pair((Object)this.contributeeParam, (Object)this.contributee);
    }

    public void setMixedIn(ManagedObject mixedInAdapter) {
        this.mixedInAdapter = mixedInAdapter;
    }

    public ManagedObject getMixedIn() {
        return this.mixedInAdapter;
    }

    public abstract T createInteractionEvent();
}

