/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.interactions;

import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.services.wrapper.events.ActionArgumentEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionContextType;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.interactions.ActionInteractionContext;
import org.apache.isis.core.metamodel.interactions.ProposedHolder;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;

public class ActionArgValidityContext
extends ValidityContext<ActionArgumentEvent>
implements ProposedHolder,
ActionInteractionContext {
    private final ObjectAction objectAction;
    private final ObjectAdapter[] args;
    private final int position;
    private final ObjectAdapter proposed;

    public ActionArgValidityContext(ObjectAdapter targetAdapter, ObjectAction objectAction, Identifier id, ObjectAdapter[] args, int position, InteractionInitiatedBy interactionInitiatedBy) {
        super(InteractionContextType.ACTION_PROPOSED_ARGUMENT, targetAdapter, id, interactionInitiatedBy);
        this.objectAction = objectAction;
        this.args = args;
        this.position = position;
        this.proposed = args[position];
    }

    @Override
    public ObjectAction getObjectAction() {
        return this.objectAction;
    }

    public ObjectAdapter[] getArgs() {
        return this.args;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public ObjectAdapter getProposed() {
        return this.proposed;
    }

    @Override
    public ActionArgumentEvent createInteractionEvent() {
        return new ActionArgumentEvent(ObjectAdapter.Util.unwrapPojo(this.getTarget()), this.getIdentifier(), ObjectAdapter.Util.unwrapPojoArray(this.getArgs()), this.getPosition());
    }
}

