/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.uuid;

import java.util.UUID;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.uuid.UUIDValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class UUIDValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<UUID>
implements UUIDValueFacet {
    public static final int MAX_LENGTH = 36;
    public static final int TYPICAL_LENGTH = 36;
    private static final UUID DEFAULT_VALUE = null;

    public static Class<? extends Facet> type() {
        return UUIDValueFacet.class;
    }

    public UUIDValueSemanticsProvider() {
        this(null, null);
    }

    public UUIDValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(UUIDValueSemanticsProvider.type(), holder, UUID.class, 36, 36, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    protected UUID doParse(Object context, String entry) {
        if (entry.trim().equals("")) {
            return null;
        }
        return UUID.fromString(entry);
    }

    @Override
    public String titleString(Object object) {
        return object == null ? "" : object.toString();
    }

    @Override
    public String titleStringWithMask(Object object, String usingMask) {
        return this.titleString(object);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected UUID doRestore(String data) {
        return UUID.fromString(data);
    }

    @Override
    public UUID uuidValue(ObjectAdapter object) {
        return object == null ? null : (UUID)object.getPojo();
    }

    @Override
    public ObjectAdapter createValue(UUID value) {
        return this.getObjectAdapterProvider().adapterFor(value);
    }

    @Override
    public String toString() {
        return "UuidValueSemanticsProvider";
    }
}

