/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.treenode;

import org.apache.isis.applib.adapters.DefaultsProvider;
import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.applib.services.urlencoding.UrlEncodingService;
import org.apache.isis.applib.tree.LazyTreeNode;
import org.apache.isis.applib.tree.TreeNode;
import org.apache.isis.applib.tree.TreeState;
import org.apache.isis.commons.internal.memento._Mementos;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.treenode.TreeNodeValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class TreeNodeValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<TreeNode>
implements TreeNodeValueFacet {
    private static final int TYPICAL_LENGTH = 0;
    private static final TreeNode DEFAULT_VALUE = null;
    private static final Class<TreeNode> VALUE_TYPE = TreeNode.class;

    private static Class<? extends Facet> type() {
        return TreeNodeValueFacet.class;
    }

    public TreeNodeValueSemanticsProvider() {
        this(null, null);
    }

    public TreeNodeValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(TreeNodeValueSemanticsProvider.type(), holder, VALUE_TYPE, 0, -1, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.NOT_HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    public String titleString(Object object) {
        return object != null ? ((TreeNode)object).toString() : "[null]";
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(value);
    }

    @Override
    public Parser<TreeNode> getParser() {
        return null;
    }

    @Override
    public DefaultsProvider<TreeNode> getDefaultsProvider() {
        return null;
    }

    @Override
    protected String doEncode(Object object) {
        TreeNode treeNode = (TreeNode)object;
        _Mementos.Memento memento = this.newMemento();
        memento.put("primaryValue", treeNode.getValue());
        memento.put("adapterClass", (Object)treeNode.getTreeAdapterClass());
        memento.put("treeState", (Object)treeNode.getTreeState());
        return memento.asString();
    }

    @Override
    protected TreeNode<?> doRestore(String input) {
        _Mementos.Memento memento = this.parseMemento(input);
        return LazyTreeNode.of((Object)memento.get("primaryValue", Object.class), (Class)((Class)memento.get("adapterClass", Class.class)), (TreeState)((TreeState)memento.get("treeState", TreeState.class)));
    }

    @Override
    public String toString() {
        return "TreeNodeValueSemanticsProvider";
    }

    private _Mementos.Memento newMemento() {
        UrlEncodingService codec = (UrlEncodingService)this.getServicesInjector().lookupServiceElseFail(UrlEncodingService.class);
        _Mementos.SerializingAdapter serializer = (_Mementos.SerializingAdapter)this.getServicesInjector().lookupServiceElseFail(_Mementos.SerializingAdapter.class);
        return _Mementos.create((_Mementos.EncoderDecoder)codec, (_Mementos.SerializingAdapter)serializer);
    }

    private _Mementos.Memento parseMemento(String input) {
        UrlEncodingService codec = (UrlEncodingService)this.getServicesInjector().lookupServiceElseFail(UrlEncodingService.class);
        _Mementos.SerializingAdapter serializer = (_Mementos.SerializingAdapter)this.getServicesInjector().lookupServiceElseFail(_Mementos.SerializingAdapter.class);
        return _Mementos.parse((_Mementos.EncoderDecoder)codec, (_Mementos.SerializingAdapter)serializer, (String)input);
    }
}

