/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.timestampsql;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.InvalidEntryException;
import org.apache.isis.core.metamodel.facets.properties.defaults.PropertyDefaultFacet;
import org.apache.isis.core.metamodel.facets.value.timestampsql.TimeStampValueSemanticsProviderAbstract;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class JavaSqlTimeStampValueSemanticsProvider
extends TimeStampValueSemanticsProviderAbstract<Timestamp> {
    private static Map<String, DateFormat> formats = _Maps.newHashMap();

    public static final boolean isAPropertyDefaultFacet() {
        return PropertyDefaultFacet.class.isAssignableFrom(JavaSqlTimeStampValueSemanticsProvider.class);
    }

    public JavaSqlTimeStampValueSemanticsProvider() {
        this(null, null);
    }

    public JavaSqlTimeStampValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(holder, Timestamp.class, context);
    }

    @Override
    protected Date dateValue(Object value) {
        return new Date(((Timestamp)value).getTime());
    }

    @Override
    protected Map<String, DateFormat> formats() {
        return formats;
    }

    @Override
    protected Timestamp now() {
        throw new InvalidEntryException("Can't change a timestamp.");
    }

    @Override
    protected Timestamp setDate(Date date) {
        return new Timestamp(date.getTime());
    }

    static {
        JavaSqlTimeStampValueSemanticsProvider.initFormats(formats);
    }
}

