/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.string;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.string.StringValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class StringValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<String>
implements StringValueFacet {
    public static final int TYPICAL_LENGTH = 25;
    private static final String DEFAULT_VALUE = null;

    public static Class<? extends Facet> type() {
        return StringValueFacet.class;
    }

    public StringValueSemanticsProvider() {
        this(null, null);
    }

    public StringValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(StringValueSemanticsProvider.type(), holder, String.class, 25, -1, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    protected String doParse(Object context, String entry) {
        if (entry.trim().equals("")) {
            return null;
        }
        return entry;
    }

    @Override
    public String titleString(Object object) {
        String string = (String)(object == null ? "" : object);
        return string;
    }

    @Override
    public String titleStringWithMask(Object object, String usingMask) {
        return this.titleString(object);
    }

    @Override
    protected String doEncode(Object object) {
        String text = (String)object;
        if (text.equals("NULL") || this.isEscaped(text)) {
            return this.escapeText(text);
        }
        return text;
    }

    @Override
    protected String doRestore(String data) {
        if (this.isEscaped(data)) {
            return data.substring(1);
        }
        return data;
    }

    private boolean isEscaped(String text) {
        return text.startsWith("/");
    }

    private String escapeText(String text) {
        return "/" + text;
    }

    @Override
    public String stringValue(ObjectAdapter object) {
        return object == null ? "" : (String)object.getPojo();
    }

    @Override
    public ObjectAdapter createValue(String value) {
        return this.getObjectAdapterProvider().adapterFor(value);
    }

    @Override
    public String toString() {
        return "StringValueSemanticsProvider";
    }
}

