/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.localrespath;

import java.nio.file.InvalidPathException;
import org.apache.isis.applib.value.LocalResourcePath;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.localrespath.LocalResourcePathValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class LocalResourcePathValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<LocalResourcePath>
implements LocalResourcePathValueFacet {
    public static final int MAX_LENGTH = 2083;
    private static final int TYPICAL_LENGTH = 100;
    private static final LocalResourcePath DEFAULT_VALUE = null;

    public static Class<? extends Facet> type() {
        return LocalResourcePathValueFacet.class;
    }

    public LocalResourcePathValueSemanticsProvider() {
        this(null, null);
    }

    public LocalResourcePathValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(LocalResourcePathValueSemanticsProvider.type(), holder, LocalResourcePath.class, 100, 2083, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    protected LocalResourcePath doParse(Object context, String entry) {
        if (entry.trim().equals("")) {
            return null;
        }
        try {
            return new LocalResourcePath(entry);
        }
        catch (InvalidPathException ex) {
            throw new IllegalArgumentException("Not parseable as a LocalResourcePath ('" + entry + "')", ex);
        }
    }

    @Override
    public String titleString(Object object) {
        return object != null ? object.toString() : "";
    }

    @Override
    public String titleStringWithMask(Object object, String usingMask) {
        return this.titleString(object);
    }

    @Override
    protected String doEncode(Object object) {
        LocalResourcePath url = (LocalResourcePath)object;
        return url != null ? url.getPath() : "NULL";
    }

    @Override
    protected LocalResourcePath doRestore(String data) {
        if ("NULL".equals(data)) {
            return null;
        }
        try {
            return new LocalResourcePath(data);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    @Override
    public LocalResourcePath localResourcePathValue(ObjectAdapter object) {
        return object == null ? null : (LocalResourcePath)object.getPojo();
    }

    @Override
    public ObjectAdapter createValue(LocalResourcePath value) {
        return this.getObjectAdapterProvider().adapterFor(value);
    }

    @Override
    public String toString() {
        return "LocalResourcePathValueSemanticsProvider";
    }
}

