/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.exceptions.UnexpectedCallException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.image.ImageValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class ImageValueSemanticsProviderAbstract<T>
extends ValueSemanticsProviderAndFacetAbstract<T>
implements ImageValueFacet {
    private static final int TYPICAL_LENGTH = 18;
    private static final Object DEFAULT_VALUE;
    private static final char[] BASE_64_CHARS;
    protected static final byte[] REVERSE_BASE_64_CHARS;
    private FacetHolder facetHolder;

    public ImageValueSemanticsProviderAbstract(FacetHolder holder, Class<T> adaptedClass, ServicesInjector context) {
        super(ImageValueFacet.class, holder, adaptedClass, 18, -1, ValueSemanticsProviderAndFacetAbstract.Immutability.NOT_IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.NOT_HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    public Parser<T> getParser() {
        return null;
    }

    @Override
    protected T doParse(Object original, String entry) {
        throw new UnexpectedCallException();
    }

    public byte[] getAsByteArray(ObjectAdapter object) {
        int[] flatIntArray = this.flatten(object);
        byte[] byteArray = new byte[flatIntArray.length * 4];
        for (int i = 0; i < flatIntArray.length; ++i) {
            int value = flatIntArray[i];
            byteArray[i * 4] = (byte)(value >> 24 & 0xFF);
            byteArray[i * 4 + 1] = (byte)(value >> 16 & 0xFF);
            byteArray[i * 4 + 2] = (byte)(value >> 8 & 0xFF);
            byteArray[i * 4 + 3] = (byte)(value & 0xFF);
        }
        return byteArray;
    }

    private static int byteArrayToInt(byte[] byteArray, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (byteArray[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    @Override
    public boolean alwaysReplace() {
        return false;
    }

    @Override
    public Facet getUnderlyingFacet() {
        return null;
    }

    @Override
    public void setUnderlyingFacet(Facet underlyingFacet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDerived() {
        return false;
    }

    public T restoreFromByteArray(byte[] byteArray) {
        int[] flatIntArray = new int[byteArray.length / 4];
        for (int i = 0; i < flatIntArray.length; ++i) {
            flatIntArray[i] = ImageValueSemanticsProviderAbstract.byteArrayToInt(byteArray, i * 4);
        }
        return this.setPixels(ImageValueSemanticsProviderAbstract.inflate(flatIntArray));
    }

    private int[] flatten(ObjectAdapter object) {
        int[][] image = this.getPixels(object);
        int[] flatArray = new int[this.getHeight(object) * this.getWidth(object) + 2];
        int flatIndex = 0;
        flatArray[flatIndex++] = this.getHeight(object);
        flatArray[flatIndex++] = this.getWidth(object);
        for (int i = 0; i < this.getHeight(object); ++i) {
            for (int j = 0; j < this.getWidth(object); ++j) {
                flatArray[flatIndex++] = image[i][j];
            }
        }
        return flatArray;
    }

    private static int[][] inflate(int[] flatIntArray) {
        int flatIndex = 0;
        int height = flatIntArray[flatIndex++];
        int width = flatIntArray[flatIndex++];
        int[][] newImage = new int[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                newImage[i][j] = flatIntArray[flatIndex++];
            }
        }
        return newImage;
    }

    @Override
    protected String doEncode(Object object) {
        int[][] image = this.getPixels(object);
        int lines = image.length;
        int width = image[0].length;
        StringBuffer encodeData = new StringBuffer(lines * width * 4);
        this.encodePixel(lines, encodeData);
        this.encodePixel(width, encodeData);
        for (int line = 0; line < lines; ++line) {
            for (int pixel = 0; pixel < width; ++pixel) {
                this.encodePixel(image[line][pixel], encodeData);
            }
        }
        return encodeData.toString();
    }

    protected Image createImage(int[][] pixels) {
        int lines = pixels.length;
        int width = pixels[0].length;
        int[] pix = new int[lines * width];
        int offset = 0;
        for (int line = 0; line < lines; ++line) {
            System.arraycopy(pixels[line], 0, pix, offset, width);
            offset += width;
        }
        MemoryImageSource source = new MemoryImageSource(width, lines, pix, 0, width);
        return Toolkit.getDefaultToolkit().createImage(source);
    }

    private int decodePixel(String data, int item) {
        int offset = item * 4;
        int pixel = 0;
        for (int i = 0; i < 4; ++i) {
            char c = data.charAt(offset + i);
            byte b = REVERSE_BASE_64_CHARS[c];
            if (i == 0 && b >= 32) {
                pixel = 255;
            }
            pixel = (pixel << 6) + b;
        }
        return pixel;
    }

    private void encodePixel(int pixel, StringBuffer encodeData) {
        if (pixel > 0x7FFFFF || pixel < -8388607) {
            // empty if block
        }
        for (int i = 3; i >= 0; --i) {
            int bitsToShift = i * 6;
            int c = pixel >> bitsToShift;
            char cc = BASE_64_CHARS[c & 0x3F];
            encodeData.append(cc);
        }
    }

    public String getIconName() {
        return null;
    }

    protected abstract int[][] getPixels(Object var1);

    protected int[][] grabPixels(Image image) {
        int width = image.getWidth(null);
        int lines = image.getHeight(null);
        int[] pixels = new int[width * lines];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, lines, pixels, 0, width);
        grabber.setColorModel(ColorModel.getRGBdefault());
        try {
            if (grabber.grabPixels() && (grabber.status() & 0x20) != 0) {
                int[][] array = new int[lines][width];
                int srcPos = 0;
                for (int line = 0; line < lines; ++line) {
                    array[line] = new int[width];
                    System.arraycopy(pixels, srcPos, array[line], 0, width);
                    for (int pixel = 0; pixel < array[line].length; ++pixel) {
                        array[line][pixel] = array[line][pixel] | 0xFF000000;
                    }
                    srcPos += width;
                }
                return array;
            }
            return new int[lines][width];
        }
        catch (InterruptedException e) {
            throw new IsisException((Throwable)e);
        }
    }

    @Override
    public T doRestore(String data) {
        int lines = this.decodePixel(data, 0);
        int width = this.decodePixel(data, 1);
        int[][] imageData = new int[lines][width];
        int offset = 2;
        for (int line = 0; line < lines; ++line) {
            for (int pixel = 0; pixel < width; ++pixel) {
                imageData[line][pixel] = this.decodePixel(data, offset++);
                imageData[line][pixel] = imageData[line][pixel] | 0xFF000000;
            }
        }
        T image = this.setPixels(imageData);
        return image;
    }

    protected abstract T setPixels(int[][] var1);

    public void setMask(String mask) {
    }

    @Override
    public String titleString(Object value) {
        return "image";
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return "image";
    }

    @Override
    public FacetHolder getFacetHolder() {
        return this.facetHolder;
    }

    @Override
    public void setFacetHolder(FacetHolder facetHolder) {
        this.facetHolder = facetHolder;
    }

    @Override
    public String toString() {
        return "ImageValueSemanticsProvider";
    }

    static {
        int i;
        DEFAULT_VALUE = null;
        BASE_64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        REVERSE_BASE_64_CHARS = new byte[256];
        for (i = 0; i < REVERSE_BASE_64_CHARS.length; ++i) {
            ImageValueSemanticsProviderAbstract.REVERSE_BASE_64_CHARS[i] = -1;
        }
        for (i = 0; i < BASE_64_CHARS.length; i = (int)((byte)(i + 1))) {
            ImageValueSemanticsProviderAbstract.REVERSE_BASE_64_CHARS[ImageValueSemanticsProviderAbstract.BASE_64_CHARS[i]] = i;
        }
    }
}

