/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.datetimejdk8offset;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.isis.applib.adapters.EncodingException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.value.datetimejoda.JodaDateTimeValueSemanticsProviderAbstract;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class Jdk8OffsetDateTimeValueSemanticsProvider
extends JodaDateTimeValueSemanticsProviderAbstract<OffsetDateTime> {
    private static final OffsetDateTime DEFAULT_VALUE = null;
    private final DateTimeFormatter encodingFormatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss.SSSZ");

    public Jdk8OffsetDateTimeValueSemanticsProvider() {
        this(null, null);
    }

    public Jdk8OffsetDateTimeValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(holder, OffsetDateTime.class, DEFAULT_VALUE, context);
    }

    @Override
    protected OffsetDateTime add(OffsetDateTime original, int years, int months, int days, int hours, int minutes) {
        if (hours != 0 || minutes != 0) {
            throw new IllegalArgumentException("cannot add non-zero hours or minutes to a DateTime");
        }
        return original.plusYears(years).plusMonths(months).plusDays(days);
    }

    @Override
    protected OffsetDateTime now() {
        return OffsetDateTime.now();
    }

    @Override
    protected Date dateValue(Object value) {
        long epochMilli = ((OffsetDateTime)value).toInstant().toEpochMilli();
        return new Date(epochMilli);
    }

    @Override
    protected OffsetDateTime setDate(Date date) {
        return OffsetDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
    }

    @Override
    protected String doEncode(Object object) {
        OffsetDateTime date = (OffsetDateTime)object;
        return this.encode(date);
    }

    private synchronized String encode(OffsetDateTime date) {
        return this.encodingFormatter.format(date);
    }

    @Override
    protected OffsetDateTime doRestore(String data) {
        try {
            return this.parse(data);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException((Throwable)e);
        }
    }

    private synchronized OffsetDateTime parse(String data) {
        return OffsetDateTime.parse(data, this.encodingFormatter);
    }
}

