/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.datetimejdk8local;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.value.datetimejdk8local.TimeFormatter;
import org.apache.isis.core.metamodel.facets.value.datetimejdk8local.TimeParser;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;

final class Jdk8LocalDateTimeUtil {
    private static final ZoneId zId = ZoneId.systemDefault();

    private Jdk8LocalDateTimeUtil() {
    }

    static TimeParser parserOf(DateTimeFormatter jodaFormatter) {
        return t -> Jdk8LocalDateTimeUtil.toJava8(jodaFormatter.withLocale(Locale.getDefault()).parseLocalDateTime(t));
    }

    private static LocalDateTime toJava8(org.joda.time.LocalDateTime x) {
        if (x == null) {
            return null;
        }
        return Jdk8LocalDateTimeUtil.toLocalDateTime(x.toDate().getTime());
    }

    private static LocalDateTime toLocalDateTime(long epochMilli) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), zId);
    }

    static TimeFormatter formatterOf(DateTimeFormatter jodaFormatter) {
        return t -> jodaFormatter.withLocale(Locale.getDefault()).print((ReadablePartial)Jdk8LocalDateTimeUtil.toJoda(t));
    }

    private static org.joda.time.LocalDateTime toJoda(LocalDateTime x) {
        if (x == null) {
            return null;
        }
        return org.joda.time.LocalDateTime.fromDateFields((Date)new Date(Jdk8LocalDateTimeUtil.toEpochMilli(x)));
    }

    private static long toEpochMilli(LocalDateTime localDateTime) {
        return localDateTime.atZone(zId).toInstant().toEpochMilli();
    }

    static LocalDateTime parseDate(String dateStr, List<TimeParser> parseFormatters) {
        return Jdk8LocalDateTimeUtil.parseDateTime(dateStr, parseFormatters);
    }

    private static LocalDateTime parseDateTime(String dateStr, Iterable<TimeParser> parsers) {
        for (TimeParser parser : parsers) {
            try {
                return (LocalDateTime)parser.apply(dateStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new TextEntryParseException("Not recognised as a date: " + dateStr);
    }

    static LocalDateTime relativeDateTime(LocalDateTime contextDate, String str, boolean add) {
        LocalDateTime relativeDate = contextDate;
        if (str.equals("")) {
            return contextDate;
        }
        try {
            StringTokenizer st = new StringTokenizer(str.substring(1), " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                relativeDate = Jdk8LocalDateTimeUtil.adjustDateTime(relativeDate, token, add);
            }
            return relativeDate;
        }
        catch (Exception e) {
            return contextDate;
        }
    }

    private static LocalDateTime adjustDateTime(LocalDateTime contextDateTime, String str, boolean add) {
        int hours = 0;
        int minutes = 0;
        int days = 0;
        int months = 0;
        int years = 0;
        if (str.endsWith("H")) {
            str = str.substring(0, str.length() - 1);
            hours = Integer.valueOf(str);
        } else if (str.endsWith("M")) {
            str = str.substring(0, str.length() - 1);
            minutes = Integer.valueOf(str);
        } else if (str.endsWith("w")) {
            str = str.substring(0, str.length() - 1);
            days = 7 * Integer.valueOf(str);
        } else if (str.endsWith("y")) {
            str = str.substring(0, str.length() - 1);
            years = Integer.valueOf(str);
        } else if (str.endsWith("m")) {
            str = str.substring(0, str.length() - 1);
            months = Integer.valueOf(str);
        } else if (str.endsWith("d")) {
            str = str.substring(0, str.length() - 1);
            days = Integer.valueOf(str);
        } else {
            days = Integer.valueOf(str);
        }
        if (add) {
            return Jdk8LocalDateTimeUtil.add(contextDateTime, years, months, days, hours, minutes);
        }
        return Jdk8LocalDateTimeUtil.add(contextDateTime, -years, -months, -days, -hours, -minutes);
    }

    private static LocalDateTime add(LocalDateTime original, int years, int months, int days, int hours, int minutes) {
        return original.plusYears(years).plusMonths(months).plusDays(days).plusHours(hours).plusMinutes(minutes);
    }

    static String titleString(TimeFormatter titleFormatter, LocalDateTime dateTime) {
        return dateTime == null ? "" : (String)titleFormatter.apply(dateTime);
    }
}

