/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.datejdk8local;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.adapters.EncodingException;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.datejdk8local.Jdk8LocalDateUtil;
import org.apache.isis.core.metamodel.facets.value.datejdk8local.Jdk8LocalDateValueFacet;
import org.apache.isis.core.metamodel.facets.value.datejdk8local.TimeFormatter;
import org.apache.isis.core.metamodel.facets.value.datejdk8local.TimeParser;
import org.apache.isis.core.metamodel.facets.value.datejodalocal.JodaLocalDateValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class Jdk8LocalDateValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<LocalDate>
implements Jdk8LocalDateValueFacet {
    public static final int MAX_LENGTH = 12;
    public static final int TYPICAL_LENGTH = 12;
    public static final String CFG_FORMAT_KEY = "isis.value.format.date";
    private static Map<String, TimeFormatter> NAMED_TITLE_FORMATTERS = _Maps.newHashMap();
    private static final ThreadLocal<String> OVERRIDE_TITLE_PATTERN;
    private static final List<TimeParser> PARSE_FORMATTERS;
    private static final LocalDate DEFAULT_VALUE;
    private final DateTimeFormatter encodingFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    private TimeFormatter titleStringFormatter;
    private String titleStringFormatNameOrPattern;

    @Deprecated
    public static void setFormat(String propertyType, String pattern) {
        Jdk8LocalDateValueSemanticsProvider.setTitlePatternOverride(pattern);
    }

    public static void setTitlePatternOverride(String pattern) {
        OVERRIDE_TITLE_PATTERN.set(pattern);
    }

    public static Class<? extends Facet> type() {
        return JodaLocalDateValueFacet.class;
    }

    public Jdk8LocalDateValueSemanticsProvider() {
        this(null, null);
    }

    public Jdk8LocalDateValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(Jdk8LocalDateValueSemanticsProvider.type(), holder, LocalDate.class, 12, 12, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
        String configuredNameOrPattern = this.getConfiguration().getString(CFG_FORMAT_KEY, "medium").trim();
        this.updateTitleStringFormatter(configuredNameOrPattern);
    }

    private void updateTitleStringFormatter(String titleStringFormatNameOrPattern) {
        this.titleStringFormatter = NAMED_TITLE_FORMATTERS.get(titleStringFormatNameOrPattern);
        if (this.titleStringFormatter == null) {
            this.titleStringFormatter = Jdk8LocalDateUtil.formatterOf(DateTimeFormatter.ofPattern(titleStringFormatNameOrPattern));
        }
        this.titleStringFormatNameOrPattern = titleStringFormatNameOrPattern;
    }

    @Override
    protected LocalDate doParse(String entry, Object context) {
        this.updateTitleStringFormatterIfOverridden();
        LocalDate contextDate = (LocalDate)context;
        String dateString = entry.trim().toUpperCase();
        if (dateString.startsWith("+") && contextDate != null) {
            return Jdk8LocalDateUtil.relativeDate(contextDate, dateString, true);
        }
        if (dateString.startsWith("-") && contextDate != null) {
            return Jdk8LocalDateUtil.relativeDate(contextDate, dateString, false);
        }
        return this.parseDate(dateString, contextDate);
    }

    private void updateTitleStringFormatterIfOverridden() {
        String overridePattern = OVERRIDE_TITLE_PATTERN.get();
        if (overridePattern == null || this.titleStringFormatNameOrPattern.equals(overridePattern)) {
            return;
        }
        this.updateTitleStringFormatter(overridePattern);
    }

    private LocalDate parseDate(String dateStr, Object original) {
        return Jdk8LocalDateUtil.parseDate(dateStr, PARSE_FORMATTERS);
    }

    @Override
    public String titleString(Object value) {
        if (value == null) {
            return null;
        }
        LocalDate date = (LocalDate)value;
        return Jdk8LocalDateUtil.titleString(this.titleStringFormatter, date);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        LocalDate date = (LocalDate)value;
        return Jdk8LocalDateUtil.titleString(Jdk8LocalDateUtil.formatterOf(DateTimeFormatter.ofPattern(usingMask)), date);
    }

    @Override
    protected String doEncode(Object object) {
        LocalDate date = (LocalDate)object;
        return this.encode(date);
    }

    private synchronized String encode(LocalDate date) {
        return this.encodingFormatter.format(date);
    }

    @Override
    protected LocalDate doRestore(String data) {
        try {
            return this.parse(data);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException((Throwable)e);
        }
    }

    private synchronized LocalDate parse(String data) {
        return LocalDate.parse(data, this.encodingFormatter);
    }

    @Override
    public final LocalDate dateValue(ObjectAdapter object) {
        return (LocalDate)(object == null ? null : object.getPojo());
    }

    @Override
    public final ObjectAdapter createValue(LocalDate date) {
        return this.getObjectAdapterProvider().adapterFor(date);
    }

    @Override
    public String toString() {
        return "Jdk8LocalDateValueSemanticsProvider: " + this.titleStringFormatter;
    }

    static {
        NAMED_TITLE_FORMATTERS.put("iso_encoding", Jdk8LocalDateUtil.formatterOf(DateTimeFormatter.ofPattern("yyyyMMdd")));
        NAMED_TITLE_FORMATTERS.put("iso", Jdk8LocalDateUtil.formatterOf(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        NAMED_TITLE_FORMATTERS.put("long", Jdk8LocalDateUtil.formatterOfStyle("L-"));
        NAMED_TITLE_FORMATTERS.put("medium", Jdk8LocalDateUtil.formatterOfStyle("M-"));
        NAMED_TITLE_FORMATTERS.put("short", Jdk8LocalDateUtil.formatterOfStyle("S-"));
        OVERRIDE_TITLE_PATTERN = new ThreadLocal<String>(){

            @Override
            protected String initialValue() {
                return null;
            }
        };
        PARSE_FORMATTERS = _Lists.newArrayList();
        PARSE_FORMATTERS.add(Jdk8LocalDateUtil.parserOfStyle("L-"));
        PARSE_FORMATTERS.add(Jdk8LocalDateUtil.parserOfStyle("M-"));
        PARSE_FORMATTERS.add(Jdk8LocalDateUtil.parserOfStyle("S-"));
        PARSE_FORMATTERS.add(Jdk8LocalDateUtil.parserOf(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        PARSE_FORMATTERS.add(Jdk8LocalDateUtil.parserOf(DateTimeFormatter.ofPattern("yyyyMMdd")));
        DEFAULT_VALUE = null;
    }
}

