/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.blobs;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.isis.applib.adapters.DefaultsProvider;
import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.blobs.BlobValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class BlobValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<Blob>
implements BlobValueFacet {
    private static final int TYPICAL_LENGTH = 0;
    private static final Blob DEFAULT_VALUE = null;

    private static Class<? extends Facet> type() {
        return BlobValueFacet.class;
    }

    public BlobValueSemanticsProvider() {
        this(null, null);
    }

    public BlobValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(BlobValueSemanticsProvider.type(), holder, Blob.class, 0, -1, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.NOT_HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    public String titleString(Object object) {
        return object != null ? ((Blob)object).getName() : "[null]";
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(value);
    }

    @Override
    public Parser<Blob> getParser() {
        return null;
    }

    @Override
    public DefaultsProvider<Blob> getDefaultsProvider() {
        return null;
    }

    @Override
    protected String doEncode(Object object) {
        Blob blob = (Blob)object;
        return blob.getName() + ":" + blob.getMimeType().getBaseType() + ":" + _Strings.ofBytes((byte[])_Bytes.encodeToBase64((Base64.Encoder)Base64.getEncoder(), (byte[])blob.getBytes()), (Charset)StandardCharsets.UTF_8);
    }

    @Override
    protected Blob doRestore(String data) {
        int colonIdx = data.indexOf(58);
        String name = data.substring(0, colonIdx);
        int colon2Idx = data.indexOf(":", colonIdx + 1);
        String mimeTypeBase = data.substring(colonIdx + 1, colon2Idx);
        String payload = data.substring(colon2Idx + 1);
        byte[] bytes = _Bytes.decodeBase64((Base64.Decoder)Base64.getDecoder(), (byte[])payload.getBytes(StandardCharsets.UTF_8));
        try {
            return new Blob(name, new MimeType(mimeTypeBase), bytes);
        }
        catch (MimeTypeParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return "BlobValueSemanticsProvider";
    }
}

