/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.ValueSemanticsProviderAbstractTemporal;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class DateAndTimeValueSemanticsProviderAbstract<T>
extends ValueSemanticsProviderAbstractTemporal<T> {
    private static Map<String, DateFormat> formats = _Maps.newHashMap();
    private static final Object DEFAULT_VALUE;
    private static final int TYPICAL_LENGTH = 18;

    public DateAndTimeValueSemanticsProviderAbstract(FacetHolder holder, Class<T> adaptedClass, ValueSemanticsProviderAndFacetAbstract.Immutability immutability, ValueSemanticsProviderAndFacetAbstract.EqualByContent equalByContent, ServicesInjector context) {
        super("datetime", holder, adaptedClass, 18, immutability, equalByContent, DEFAULT_VALUE, context);
        String formatRequired = this.getConfiguration().getString("isis.value.format.datetime");
        if (formatRequired == null) {
            this.format = this.formats().get(this.defaultFormat());
        } else {
            this.setMask(formatRequired);
        }
    }

    @Override
    protected String defaultFormat() {
        return "medium";
    }

    @Override
    protected Map<String, DateFormat> formats() {
        return formats;
    }

    @Override
    protected DateFormat format() {
        Locale locale = Locale.getDefault();
        TimeZone timeZone = TimeZone.getDefault();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, locale);
        dateFormat.setTimeZone(timeZone);
        return dateFormat;
    }

    @Override
    public String toString() {
        return "JavaDateTimeValueSemanticsProvider: " + this.format;
    }

    @Override
    protected List<DateFormat> formatsToTry() {
        ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
        Locale locale = Locale.getDefault();
        TimeZone timeZone = TimeZone.getDefault();
        formats.add(DateFormat.getDateTimeInstance(1, 1, locale));
        formats.add(DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        formats.add(DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyyMMdd'T'HHmmssSSS"));
        formats.add(DateFormat.getDateTimeInstance(2, 3, locale));
        formats.add(DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyy-MM-dd HH:mm:ss"));
        formats.add(DateFormat.getDateTimeInstance(3, 3, locale));
        formats.add(DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyyMMdd'T'HHmmss"));
        formats.add(DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyy-MM-dd HH:mm"));
        formats.add(DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyyMMdd'T'HHmm"));
        formats.add(DateAndTimeValueSemanticsProviderAbstract.createDateFormat("dd-MMM-yyyy HH:mm"));
        for (DateFormat format : formats) {
            format.setTimeZone(timeZone);
        }
        return formats;
    }

    static {
        formats.put("iso_encoding", DateAndTimeValueSemanticsProviderAbstract.createDateEncodingFormat("yyyyMMdd'T'HHmmssSSS"));
        formats.put("iso", DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyy-MM-dd HH:mm"));
        formats.put("medium", DateFormat.getDateTimeInstance(2, 3));
        DEFAULT_VALUE = null;
    }
}

