/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.propertylayout;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.labelat.LabelAtFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.multiline.MultiLineFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.renderedadjusted.RenderedAdjustedFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.CssClassFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.DescribedAsFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.HiddenFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.LabelAtFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.MultiLineFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.NamedFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.PromptStyleFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.RenderedAdjustedFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.TypicalLengthFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.UnchangingFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.renderunchanged.UnchangingFacet;

public class PropertyLayoutFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public PropertyLayoutFacetFactory() {
        super(FeatureType.PROPERTIES_AND_ACTIONS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod holder = this.facetHolderFrom(processMethodContext);
        List<PropertyLayout> propertyLayouts = this.propertyLayoutsFrom(processMethodContext);
        this.processCssClass(holder, propertyLayouts);
        this.processDescribedAs(holder, propertyLayouts);
        this.processPromptStyle(holder, propertyLayouts);
        this.processHidden(holder, propertyLayouts);
        this.processLabelAt(holder, propertyLayouts);
        this.processMultiLine(holder, propertyLayouts);
        this.processNamed(holder, propertyLayouts);
        this.processRenderedAdjusted(holder, propertyLayouts);
        this.processTypicalLength(holder, propertyLayouts);
        this.processUnchanging(holder, propertyLayouts);
    }

    void processCssClass(FacetHolder holder, List<PropertyLayout> propertyLayout) {
        CssClassFacet cssClassFacet = CssClassFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        FacetUtil.addFacet(cssClassFacet);
    }

    void processDescribedAs(FacetHolder holder, List<PropertyLayout> propertyLayout) {
        DescribedAsFacet describedAsFacet = DescribedAsFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        FacetUtil.addFacet(describedAsFacet);
    }

    void processPromptStyle(FacetHolder holder, List<PropertyLayout> propertyLayout) {
        FacetedMethod facetedMethod;
        if (holder instanceof FacetedMethod && (facetedMethod = (FacetedMethod)holder).getFeatureType() != FeatureType.PROPERTY) {
            return;
        }
        PromptStyleFacet promptStyleFacet = PromptStyleFacetForPropertyLayoutAnnotation.create(propertyLayout, this.getConfiguration(), holder);
        FacetUtil.addFacet(promptStyleFacet);
    }

    void processHidden(FacetHolder holder, List<PropertyLayout> propertyLayout) {
        HiddenFacet hiddenFacet = HiddenFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        FacetUtil.addFacet(hiddenFacet);
    }

    void processLabelAt(FacetHolder holder, List<PropertyLayout> propertyLayout) {
        LabelAtFacet labelAtFacet = LabelAtFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        FacetUtil.addFacet(labelAtFacet);
    }

    void processMultiLine(FacetHolder holder, List<PropertyLayout> propertyLayout) {
        MultiLineFacet multiLineFacet = MultiLineFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        FacetUtil.addFacet(multiLineFacet);
    }

    void processNamed(FacetHolder holder, List<PropertyLayout> propertyLayout) {
        NamedFacet namedFacet = NamedFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        FacetUtil.addFacet(namedFacet);
    }

    void processRenderedAdjusted(FacetHolder holder, List<PropertyLayout> propertyLayout) {
        RenderedAdjustedFacet renderedAdjustedFacet = RenderedAdjustedFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        FacetUtil.addFacet(renderedAdjustedFacet);
    }

    void processTypicalLength(FacetHolder holder, List<PropertyLayout> propertyLayout) {
        TypicalLengthFacet typicalLengthFacet = TypicalLengthFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        FacetUtil.addFacet(typicalLengthFacet);
    }

    void processUnchanging(FacetHolder holder, List<PropertyLayout> propertyLayout) {
        UnchangingFacet unchangingFacet = UnchangingFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        FacetUtil.addFacet(unchangingFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        Facet cssClassFacet = null;
        FacetUtil.addFacet(cssClassFacet);
        Facet describedAsFacet = null;
        FacetUtil.addFacet(describedAsFacet);
        MultiTypedFacet hiddenFacet = null;
        FacetUtil.addFacet(hiddenFacet);
        Facet labelAtFacet = null;
        FacetUtil.addFacet(labelAtFacet);
        Facet multiLineFacet = null;
        FacetUtil.addFacet(multiLineFacet);
        Facet namedFacet = null;
        FacetUtil.addFacet(namedFacet);
        Facet renderedAdjustedFacet = null;
        FacetUtil.addFacet(renderedAdjustedFacet);
        Facet typicalLengthFacet = null;
        FacetUtil.addFacet(typicalLengthFacet);
    }

    FacetedMethod facetHolderFrom(FacetFactory.ProcessMethodContext processMethodContext) {
        return (FacetedMethod)processMethodContext.getFacetHolder();
    }

    List<PropertyLayout> propertyLayoutsFrom(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        return Annotations.getAnnotations(method, PropertyLayout.class);
    }
}

