/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property.regex;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacetAbstract;

public class RegExFacetForPropertyAnnotation
extends RegExFacetAbstract {
    private final Pattern pattern;

    public static RegExFacet create(List<Property> properties, Class<?> returnType, FacetHolder holder) {
        if (!Annotations.isString(returnType)) {
            return null;
        }
        return properties.stream().filter(property -> _Strings.emptyToNull((String)property.regexPattern()) != null).findFirst().map(property -> new RegExFacetForPropertyAnnotation(property.regexPattern(), property.regexPatternFlags(), holder, property.regexPatternReplacement())).orElse(null);
    }

    private RegExFacetForPropertyAnnotation(String pattern, int patternFlags, FacetHolder holder, String replacement) {
        super(pattern, patternFlags, replacement, holder);
        this.pattern = Pattern.compile(pattern, this.patternFlags());
    }

    @Override
    public boolean doesNotMatch(String text) {
        return text == null || !this.pattern.matcher(text).matches();
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("pattern", this.pattern);
    }
}

