/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property.publishing;

import java.util.List;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.properties.property.publishing.PublishPropertiesConfiguration;
import org.apache.isis.core.metamodel.facets.properties.property.publishing.PublishedPropertyFacetForPropertyAnnotationAsConfigured;
import org.apache.isis.core.metamodel.facets.properties.property.publishing.PublishedPropertyFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.properties.publish.PublishedPropertyFacet;
import org.apache.isis.core.metamodel.facets.properties.publish.PublishedPropertyFacetAbstract;

public class PublishedPropertyFacetForPropertyAnnotation
extends PublishedPropertyFacetAbstract {
    public static PublishedPropertyFacet create(List<Property> properties, IsisConfiguration configuration, FacetHolder holder) {
        PublishPropertiesConfiguration setting = PublishPropertiesConfiguration.parse(configuration);
        return properties.stream().map(Property::publishing).filter(publishing -> publishing != Publishing.NOT_SPECIFIED).findFirst().map(publishing -> {
            switch (publishing) {
                case AS_CONFIGURED: {
                    switch (setting) {
                        case NONE: {
                            return null;
                        }
                    }
                    return new PublishedPropertyFacetForPropertyAnnotationAsConfigured(holder);
                }
                case DISABLED: {
                    return null;
                }
                case ENABLED: {
                    return new PublishedPropertyFacetForPropertyAnnotation(holder);
                }
            }
            return null;
        }).orElseGet(() -> {
            switch (setting) {
                case NONE: {
                    return null;
                }
            }
            return new PublishedPropertyFacetFromConfiguration(holder);
        });
    }

    public PublishedPropertyFacetForPropertyAnnotation(FacetHolder holder) {
        super(holder);
    }
}

