/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property.modify;

import java.util.Map;
import org.apache.isis.applib.events.domain.AbstractDomainEvent;
import org.apache.isis.applib.events.domain.PropertyDomainEvent;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.wrapper.events.UsabilityEvent;
import org.apache.isis.applib.services.wrapper.events.ValidityEvent;
import org.apache.isis.applib.services.wrapper.events.VisibilityEvent;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.DomainEventHelper;
import org.apache.isis.core.metamodel.facets.SingleClassValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacet;
import org.apache.isis.core.metamodel.interactions.ProposedHolder;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public abstract class PropertyDomainEventFacetAbstract
extends SingleClassValueFacetAbstract
implements PropertyDomainEventFacet {
    private final DomainEventHelper domainEventHelper;
    private final PropertyOrCollectionAccessorFacet getterFacetIfAny;
    private final TranslationService translationService;
    private final String translationContext;
    private Class<? extends PropertyDomainEvent<?, ?>> eventType;

    public PropertyDomainEventFacetAbstract(Class<? extends PropertyDomainEvent<?, ?>> eventType, PropertyOrCollectionAccessorFacet getterFacetIfAny, FacetHolder holder, ServicesInjector servicesInjector, SpecificationLoader specificationLoader) {
        super(PropertyDomainEventFacet.class, holder, eventType, specificationLoader);
        this.eventType = eventType;
        this.getterFacetIfAny = getterFacetIfAny;
        this.translationService = servicesInjector.lookupService(TranslationService.class).orElse(null);
        this.translationContext = ((IdentifiedHolder)holder).getIdentifier().toClassAndNameIdentityString();
        this.domainEventHelper = new DomainEventHelper(servicesInjector);
    }

    @Override
    public Class<?> value() {
        return this.eventType;
    }

    public <S, T> Class<? extends PropertyDomainEvent<S, T>> getEventType() {
        return (Class)_Casts.uncheckedCast(this.eventType);
    }

    public void setEventType(Class<? extends PropertyDomainEvent<?, ?>> eventType) {
        this.eventType = eventType;
    }

    @Override
    public String hides(VisibilityContext<? extends VisibilityEvent> ic) {
        PropertyDomainEvent event = this.domainEventHelper.postEventForProperty(AbstractDomainEvent.Phase.HIDE, this.getEventType(), null, this.getIdentified(), ic.getTarget(), ic.getMixedIn(), null, null);
        if (event != null && event.isHidden()) {
            return "Hidden by subscriber";
        }
        return null;
    }

    @Override
    public String disables(UsabilityContext<? extends UsabilityEvent> ic) {
        PropertyDomainEvent event = this.domainEventHelper.postEventForProperty(AbstractDomainEvent.Phase.DISABLE, this.getEventType(), null, this.getIdentified(), ic.getTarget(), ic.getMixedIn(), null, null);
        if (event != null && event.isDisabled()) {
            TranslatableString reasonTranslatable = event.getDisabledReasonTranslatable();
            if (reasonTranslatable != null) {
                return reasonTranslatable.translate(this.translationService, this.translationContext);
            }
            return event.getDisabledReason();
        }
        return null;
    }

    @Override
    public String invalidates(ValidityContext<? extends ValidityEvent> ic) {
        if (this.getterFacetIfAny == null) {
            return null;
        }
        if (!(ic instanceof ProposedHolder)) {
            return null;
        }
        ProposedHolder ph = (ProposedHolder)((Object)ic);
        Object oldValue = this.getterFacetIfAny.getProperty(ic.getTarget(), ic.getInitiatedBy());
        ManagedObject proposedAdapter = ph.getProposed();
        Object proposedValue = proposedAdapter != null ? proposedAdapter.getPojo() : null;
        PropertyDomainEvent event = this.domainEventHelper.postEventForProperty(AbstractDomainEvent.Phase.VALIDATE, this.getEventType(), null, this.getIdentified(), ic.getTarget(), ic.getMixedIn(), oldValue, proposedValue);
        if (event != null && event.isInvalid()) {
            TranslatableString reasonTranslatable = event.getInvalidityReasonTranslatable();
            if (reasonTranslatable != null) {
                return reasonTranslatable.translate(this.translationService, this.translationContext);
            }
            return event.getInvalidityReason();
        }
        return null;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("getterFacet", this.getterFacetIfAny);
    }
}

