/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property.command;

import java.util.List;
import org.apache.isis.applib.annotation.CommandExecuteIn;
import org.apache.isis.applib.annotation.CommandPersistence;
import org.apache.isis.applib.annotation.CommandReification;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.services.command.CommandDtoProcessor;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.actions.action.command.CommandFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacet;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacetAbstract;
import org.apache.isis.core.metamodel.facets.properties.property.command.CommandFacetForPropertyAnnotationAsConfigured;
import org.apache.isis.core.metamodel.facets.properties.property.command.CommandPropertiesConfiguration;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class CommandFacetForPropertyAnnotation
extends CommandFacetAbstract {
    public static CommandFacet create(List<Property> properties, IsisConfiguration configuration, FacetHolder holder, ServicesInjector servicesInjector) {
        CommandPropertiesConfiguration setting = CommandPropertiesConfiguration.parse(configuration);
        return properties.stream().filter(property -> property.command() != CommandReification.NOT_SPECIFIED).findFirst().map(property -> {
            CommandReification command = property.command();
            CommandPersistence commandPersistence = property.commandPersistence();
            CommandExecuteIn commandExecuteIn = property.commandExecuteIn();
            Class processorClass = property != null ? property.commandDtoProcessor() : null;
            CommandDtoProcessor processor = CommandFacetForPropertyAnnotation.newProcessorElseNull(processorClass);
            if (processor != null) {
                command = CommandReification.ENABLED;
            }
            switch (command) {
                case AS_CONFIGURED: {
                    switch (setting) {
                        case NONE: {
                            return null;
                        }
                    }
                    return new CommandFacetForPropertyAnnotationAsConfigured(commandPersistence, commandExecuteIn, CommandFacetAbstract.Enablement.ENABLED, holder, servicesInjector);
                }
                case DISABLED: {
                    return null;
                }
                case ENABLED: {
                    return new CommandFacetForPropertyAnnotation(commandPersistence, commandExecuteIn, CommandFacetAbstract.Enablement.ENABLED, holder, processor, servicesInjector);
                }
            }
            throw new IllegalStateException("command '" + command + "' not recognised");
        }).orElseGet(() -> {
            switch (setting) {
                case NONE: {
                    return null;
                }
            }
            return CommandFacetFromConfiguration.create(holder, servicesInjector);
        });
    }

    CommandFacetForPropertyAnnotation(CommandPersistence persistence, CommandExecuteIn executeIn, CommandFacetAbstract.Enablement enablement, FacetHolder holder, CommandDtoProcessor processor, ServicesInjector servicesInjector) {
        super(persistence, executeIn, enablement, processor, holder, servicesInjector);
    }
}

