/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.autocomplete.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.param.autocomplete.MinLengthUtil;
import org.apache.isis.core.metamodel.facets.properties.autocomplete.PropertyAutoCompleteFacetAbstract;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.AuthenticationSessionProvider;

public class PropertyAutoCompleteFacetMethod
extends PropertyAutoCompleteFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesClass;
    private final int minLength;
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final ObjectAdapterProvider adapterProvider;
    private SpecificationLoader specificationLoader;

    public PropertyAutoCompleteFacetMethod(Method method, Class<?> choicesClass, FacetHolder holder, SpecificationLoader specificationLoader, AuthenticationSessionProvider authenticationSessionProvider, ObjectAdapterProvider adapterProvider) {
        super(holder);
        this.method = method;
        this.choicesClass = choicesClass;
        this.specificationLoader = specificationLoader;
        this.authenticationSessionProvider = authenticationSessionProvider;
        this.adapterProvider = adapterProvider;
        this.minLength = MinLengthUtil.determineMinLength(method);
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public Object[] autoComplete(ObjectAdapter owningAdapter, String searchArg, InteractionInitiatedBy interactionInitiatedBy) {
        Object collectionOrArray = ObjectAdapter.InvokeUtils.invoke(this.method, (ManagedObject)owningAdapter, searchArg);
        if (collectionOrArray == null) {
            return null;
        }
        ObjectAdapter collectionAdapter = this.getObjectAdapterProvider().adapterFor(collectionOrArray);
        FacetedMethod facetedMethod = (FacetedMethod)this.getFacetHolder();
        Class<?> propertyType = facetedMethod.getType();
        List<ObjectAdapter> visibleAdapters = ObjectAdapter.Util.visibleAdapters(collectionAdapter, interactionInitiatedBy);
        List filteredObjects = _Lists.map(visibleAdapters, ObjectAdapter.Util::unwrapPojo);
        ObjectSpecification propertySpec = this.getSpecification(propertyType);
        return CollectionUtils.getCollectionAsObjectArray(filteredObjects, propertySpec, this.getObjectAdapterProvider());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",class=" + this.choicesClass;
    }

    protected ObjectSpecification getSpecification(Class<?> type) {
        return type != null ? this.getSpecificationLoader().loadSpecification(type) : null;
    }

    protected ObjectAdapterProvider getObjectAdapterProvider() {
        return this.adapterProvider;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.authenticationSessionProvider.getAuthenticationSession();
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
        attributeMap.put("choicesType", this.choicesClass);
        attributeMap.put("minLength", this.minLength);
    }
}

