/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.layout;

import java.util.List;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.param.layout.CssClassFacetForParameterLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.param.layout.DescribedAsFacetForParameterLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.param.layout.LabelAtFacetForParameterLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.param.layout.MultiLineFacetForParameterLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.param.layout.NamedFacetForParameterLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.param.layout.RenderedAdjustedFacetForParameterLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.param.layout.TypicalLengthFacetForParameterLayoutAnnotation;

public class ParameterLayoutFacetFactory
extends FacetFactoryAbstract {
    public ParameterLayoutFacetFactory() {
        super(FeatureType.PARAMETERS_ONLY);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Class<?>[] parameterTypes = processParameterContext.getMethod().getParameterTypes();
        if (processParameterContext.getParamNum() >= parameterTypes.length) {
            return;
        }
        List<ParameterLayout> parameterLayouts = Annotations.getAnnotations(processParameterContext.getMethod(), processParameterContext.getParamNum(), ParameterLayout.class);
        this.addFacets(processParameterContext, parameterLayouts);
    }

    protected void addFacets(FacetFactory.ProcessParameterContext processParameterContext, List<ParameterLayout> parameterLayouts) {
        FacetedMethodParameter facetHolder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        FacetUtil.addFacet(CssClassFacetForParameterLayoutAnnotation.create(parameterLayouts, facetHolder));
        FacetUtil.addFacet(DescribedAsFacetForParameterLayoutAnnotation.create(parameterLayouts, facetHolder));
        FacetUtil.addFacet(LabelAtFacetForParameterLayoutAnnotation.create(parameterLayouts, facetHolder));
        FacetUtil.addFacet(MultiLineFacetForParameterLayoutAnnotation.create(parameterLayouts, facetHolder));
        FacetUtil.addFacet(NamedFacetForParameterLayoutAnnotation.create(parameterLayouts, facetHolder));
        FacetUtil.addFacet(RenderedAdjustedFacetForParameterLayoutAnnotation.create(parameterLayouts, facetHolder));
        FacetUtil.addFacet(TypicalLengthFacetForParameterLayoutAnnotation.create(parameterLayouts, facetHolder));
    }
}

