/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.defaults.methodnum;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.param.defaults.ActionParameterDefaultsFacetAbstract;

public class ActionParameterDefaultsFacetViaMethod
extends ActionParameterDefaultsFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final ObjectAdapterProvider adapterProvider;

    public ActionParameterDefaultsFacetViaMethod(Method method, FacetHolder holder, ObjectAdapterProvider adapterProvider) {
        super(holder);
        this.method = method;
        this.adapterProvider = adapterProvider;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.DEFAULTS;
    }

    @Override
    public Object getDefault(ObjectAdapter target, List<ObjectAdapter> argumentsIfAvailable) {
        return ObjectAdapter.InvokeUtils.invokeAutofit(this.method, target, argumentsIfAvailable);
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    protected ObjectAdapterProvider getObjectAdapterProvider() {
        return this.adapterProvider;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
    }
}

