/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.choices.methodnum;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.param.choices.ActionChoicesFacet;
import org.apache.isis.core.metamodel.facets.param.choices.methodnum.ActionParameterChoicesFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class ActionParameterChoicesFacetViaMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[0];
    ObjectAdapterProvider adapterProvider;

    public ActionParameterChoicesFacetViaMethodFactory() {
        super(FeatureType.ACTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
        List<FacetedMethodParameter> holderList = facetedMethod.getParameters();
        this.attachChoicesFacetForParametersIfChoicesNumMethodIsFound(processMethodContext, holderList);
    }

    private void attachChoicesFacetForParametersIfChoicesNumMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext, List<FacetedMethodParameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Method actionMethod = processMethodContext.getMethod();
        Class<?>[] paramTypes = actionMethod.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> arrayOfParamType = Array.newInstance(paramTypes[i], 0).getClass();
            Method choicesMethod = ActionParameterChoicesFacetViaMethodFactory.findChoicesNumMethodReturning(processMethodContext, i);
            if (choicesMethod == null) continue;
            processMethodContext.removeMethod(choicesMethod);
            FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
            if (facetedMethod.containsDoOpFacet(ActionChoicesFacet.class)) {
                Class<?> cls = processMethodContext.getCls();
                throw new MetaModelException(cls + " uses both old and new choices syntax - must use one or other");
            }
            FacetedMethodParameter paramAsHolder = parameters.get(i);
            FacetUtil.addFacet(new ActionParameterChoicesFacetViaMethod(choicesMethod, arrayOfParamType, paramAsHolder, this.getSpecificationLoader(), this.getAuthenticationSessionProvider(), this.adapterProvider));
        }
    }

    private static Method findChoicesNumMethodReturning(FacetFactory.ProcessMethodContext processMethodContext, int n) {
        Method actionMethod = processMethodContext.getMethod();
        List<Class<?>> paramTypes = ListExtensions.mutableCopy(actionMethod.getParameterTypes());
        Class<?> arrayOfParamType = Array.newInstance(paramTypes.get(n), 0).getClass();
        int numParamTypes = paramTypes.size();
        for (int i = 0; i < numParamTypes + 1; ++i) {
            Method method = ActionParameterChoicesFacetViaMethodFactory.findChoicesNumMethodReturning(processMethodContext, n, paramTypes.toArray(new Class[0]), arrayOfParamType);
            if (method != null) {
                return method;
            }
            method = ActionParameterChoicesFacetViaMethodFactory.findChoicesNumMethodReturning(processMethodContext, n, paramTypes.toArray(new Class[0]), Collection.class);
            if (method != null) {
                return method;
            }
            if (paramTypes.isEmpty()) continue;
            paramTypes.remove(paramTypes.size() - 1);
        }
        return null;
    }

    private static Method findChoicesNumMethodReturning(FacetFactory.ProcessMethodContext processMethodContext, int n, Class<?>[] paramTypes, Class<?> returnType) {
        Class<?> cls = processMethodContext.getCls();
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        String name = "choices" + n + capitalizedName;
        return MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, name, returnType, paramTypes);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        this.adapterProvider = servicesInjector.getPersistenceSessionServiceInternal();
    }
}

