/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.autocomplete.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.commons.internal._Constants;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.param.autocomplete.ActionParameterAutoCompleteFacetAbstract;
import org.apache.isis.core.metamodel.facets.param.autocomplete.MinLengthUtil;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.security.authentication.AuthenticationSessionProvider;

public class ActionParameterAutoCompleteFacetViaMethod
extends ActionParameterAutoCompleteFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesType;
    private final int minLength;

    public ActionParameterAutoCompleteFacetViaMethod(Method method, Class<?> choicesType, FacetHolder holder, SpecificationLoader specificationLookup, AuthenticationSessionProvider authenticationSessionProvider, ObjectAdapterProvider adapterManager) {
        super(holder, specificationLookup, authenticationSessionProvider, adapterManager);
        this.method = method;
        this.choicesType = choicesType;
        this.minLength = MinLengthUtil.determineMinLength(method);
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public Object[] autoComplete(ObjectAdapter owningAdapter, String searchArg, InteractionInitiatedBy interactionInitiatedBy) {
        Object collectionOrArray = ObjectAdapter.InvokeUtils.invoke(this.method, (ManagedObject)owningAdapter, searchArg);
        if (collectionOrArray == null) {
            return _Constants.emptyObjects;
        }
        ObjectAdapter collectionAdapter = this.getObjectAdapterProvider().adapterFor(collectionOrArray);
        FacetedMethodParameter facetedMethodParameter = (FacetedMethodParameter)this.getFacetHolder();
        Class<?> parameterType = facetedMethodParameter.getType();
        List<ObjectAdapter> visibleAdapters = ObjectAdapter.Util.visibleAdapters(collectionAdapter, interactionInitiatedBy);
        List visibleObjects = _Lists.map(visibleAdapters, ObjectAdapter.Util::unwrapPojo);
        ObjectSpecification parameterSpec = this.getSpecification(parameterType);
        return CollectionUtils.getCollectionAsObjectArray(visibleObjects, parameterSpec, this.getObjectAdapterProvider());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",type=" + this.choicesType;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
        attributeMap.put("choicesType", this.choicesType);
        attributeMap.put("minLength", this.minLength);
    }
}

