/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.value.vsp;

import org.apache.isis.applib.adapters.ValueSemanticsProvider;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;

public final class ValueSemanticsProviderUtil {
    public static final String SEMANTICS_PROVIDER_NAME_KEY_PREFIX = "isis.core.progmodel.value.";
    public static final String SEMANTICS_PROVIDER_NAME_KEY_SUFFIX = ".semanticsProviderName";

    private ValueSemanticsProviderUtil() {
    }

    public static String semanticsProviderNameFromConfiguration(Class<?> type, IsisConfiguration configuration) {
        String key = SEMANTICS_PROVIDER_NAME_KEY_PREFIX + type.getCanonicalName() + SEMANTICS_PROVIDER_NAME_KEY_SUFFIX;
        String semanticsProviderName = configuration.getString(key);
        return !_Strings.isNullOrEmpty((CharSequence)semanticsProviderName) ? semanticsProviderName : null;
    }

    public static Class<? extends ValueSemanticsProvider<?>> valueSemanticsProviderOrNull(Class<?> candidateClass, String classCandidateName) {
        Class clazz = candidateClass != null ? (Class)_Casts.uncheckedCast(ClassUtil.implementingClassOrNull(candidateClass.getName(), ValueSemanticsProvider.class, FacetHolder.class)) : null;
        return clazz != null ? clazz : (Class)_Casts.uncheckedCast(ClassUtil.implementingClassOrNull(classCandidateName, ValueSemanticsProvider.class, FacetHolder.class));
    }
}

