/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.title.annotation;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.object.title.annotation.TitleFacetViaTitleAnnotation;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class TitleAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    private static final String TITLE_METHOD_NAME = "title";
    ObjectAdapterProvider adapterProvider;

    public TitleAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        List<Annotations.Evaluator<Title>> evaluators = Annotations.getEvaluators(cls, Title.class);
        if (evaluators.isEmpty()) {
            return;
        }
        TitleAnnotationFacetFactory.sort(evaluators);
        List titleComponents = _Lists.map(evaluators, TitleFacetViaTitleAnnotation.TitleComponent.FROM_EVALUATORS);
        FacetUtil.addFacet(new TitleFacetViaTitleAnnotation(titleComponents, (FacetHolder)facetHolder, this.adapterProvider));
    }

    public static void sort(List<Annotations.Evaluator<Title>> evaluators) {
        Collections.sort(evaluators, new Comparator<Annotations.Evaluator<Title>>(){
            Comparator<String> comparator = new SequenceComparator();

            @Override
            public int compare(Annotations.Evaluator<Title> o1, Annotations.Evaluator<Title> o2) {
                Title a1 = o1.getAnnotation();
                Title a2 = o2.getAnnotation();
                return this.comparator.compare(a1.sequence(), a2.sequence());
            }
        });
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                Class<?> cls = objectSpec.getCorrespondingClass();
                Method titleMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, TitleAnnotationFacetFactory.TITLE_METHOD_NAME, String.class, null);
                if (titleMethod == null) {
                    return true;
                }
                Class<?> supClass = cls.getSuperclass();
                if (supClass == null) {
                    return true;
                }
                List<Method> methods = this.methodsWithTitleAnnotation(cls);
                List<Method> superClassMethods = this.methodsWithTitleAnnotation(supClass);
                if (methods.size() > superClassMethods.size()) {
                    validationFailures.add("%s: conflict for determining a strategy for retrieval of title for class, contains a method '%s' and an annotation '@%s'", objectSpec.getIdentifier().getClassName(), TitleAnnotationFacetFactory.TITLE_METHOD_NAME, Title.class.getName());
                }
                return true;
            }

            private List<Method> methodsWithTitleAnnotation(Class<?> cls) {
                return MethodFinderUtils.findMethodsWithAnnotation(cls, MethodScope.OBJECT, Title.class);
            }
        }));
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        this.adapterProvider = servicesInjector.getPersistenceSessionServiceInternal();
    }

    static class SequenceComparator
    implements Comparator<String> {
        SequenceComparator() {
        }

        @Override
        public int compare(String sequence1, String sequence2) {
            List<String> components1 = SequenceComparator.componentsFor(sequence1);
            List<String> components2 = SequenceComparator.componentsFor(sequence2);
            int size1 = components1.size();
            int size2 = components2.size();
            if (size1 == 0 && size2 == 0) {
                return 0;
            }
            int n = 0;
            int length;
            while (size1 >= (length = n + 1) || size2 < length) {
                if (size2 < length && size1 >= length) {
                    return 1;
                }
                if (size1 < length && size2 < length) {
                    return 0;
                }
                int componentCompare = 0;
                try {
                    Integer c1 = Integer.valueOf(components1.get(n));
                    Integer c2 = Integer.valueOf(components2.get(n));
                    componentCompare = c1.compareTo(c2);
                }
                catch (NumberFormatException nfe) {
                    componentCompare = components1.get(n).compareTo(components2.get(n));
                }
                if (componentCompare != 0) {
                    return componentCompare;
                }
                ++n;
            }
            return -1;
        }

        private static List<String> componentsFor(String sequence) {
            return _Strings.splitThenStream((String)sequence, (String)".").collect(Collectors.toList());
        }
    }
}

