/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.objectvalidprops.impl;

import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.objectvalidprops.ObjectValidPropertiesFacetAbstract;
import org.apache.isis.core.metamodel.interactions.ObjectValidityContext;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;

public class ObjectValidPropertiesFacetImpl
extends ObjectValidPropertiesFacetAbstract {
    private final Where where = Where.ANYWHERE;

    public ObjectValidPropertiesFacetImpl(FacetHolder holder) {
        super(holder);
    }

    @Override
    public String invalidReason(ObjectValidityContext context) {
        StringBuilder buf = new StringBuilder();
        ManagedObject adapter = context.getTarget();
        adapter.getSpecification().streamAssociations(Contributed.EXCLUDED).filter(ObjectAssociation.Predicates.PROPERTIES).filter(property -> property.isVisible(adapter, context.getInitiatedBy(), this.where).isVetoed()).filter(property -> property.isUsable(adapter, context.getInitiatedBy(), this.where).isVetoed()).forEach(property -> {
            OneToOneAssociation otoa = (OneToOneAssociation)property;
            ManagedObject value = otoa.get2(adapter, context.getInitiatedBy());
            if (otoa.isAssociationValid(adapter, value, context.getInitiatedBy()).isVetoed()) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(property.getName());
            }
        });
        if (buf.length() > 0) {
            return "Invalid properties: " + buf.toString();
        }
        return null;
    }
}

