/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.mixin;

import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.Nature;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacet;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacetAbstract;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class MixinFacetForDomainObjectAnnotation
extends MixinFacetAbstract {
    public static Class<? extends Facet> type() {
        return MixinFacet.class;
    }

    private MixinFacetForDomainObjectAnnotation(Class<?> mixinType, String value, Class<?> constructorType, FacetHolder holder, ServicesInjector servicesInjector) {
        super(mixinType, value, constructorType, holder, servicesInjector);
    }

    public static MixinFacet create(List<DomainObject> domainObjects, Class<?> candidateMixinType, FacetHolder facetHolder, ServicesInjector servicesInjector) {
        return domainObjects.stream().filter(domainObject -> domainObject.nature() == Nature.MIXIN).findFirst().map(domainObject -> {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = candidateMixinType.getConstructors()) {
                Class<?>[] constructorTypes = constructor.getParameterTypes();
                if (constructorTypes.length != 1) continue;
                Class<?> constructorType = constructorTypes[0];
                return new MixinFacetForDomainObjectAnnotation(candidateMixinType, domainObject.mixinMethod(), constructorType, facetHolder, servicesInjector);
            }
            return null;
        }).orElse(null);
    }
}

