/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.layout;

import java.lang.reflect.Method;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.layout.LayoutFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.layout.LayoutFacetFallback;
import org.apache.isis.core.metamodel.facets.object.layout.LayoutFacetMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class LayoutFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String LAYOUT_METHOD_NAME = "layout";
    private static final String[] PREFIXES = new String[]{"layout"};

    public LayoutFacetFactory() {
        super(FeatureType.OBJECTS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        LayoutFacetAbstract facet;
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, LAYOUT_METHOD_NAME, String.class, NO_PARAMETERS_TYPES);
        if (method == null) {
            facet = new LayoutFacetFallback((FacetHolder)facetHolder);
        } else {
            processClassContext.removeMethod(method);
            facet = new LayoutFacetMethod(method, (FacetHolder)facetHolder);
        }
        FacetUtil.addFacet(facet);
    }
}

