/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.ignore.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;

public class RemoveAnnotatedMethodsFacetFactory
extends FacetFactoryAbstract {
    private final List<String> eventHandlerClassNames = _Lists.of((Object[])new String[]{"org.axonframework.eventhandling.EventHandler", "org.axonframework.eventhandling.annotation.EventHandler", "com.google.common.eventbus.Subscribe"});
    private final List<Class<? extends Annotation>> eventHandlerClasses = this.eventHandlerClassNames.stream().map(name -> {
        Class eventHandlerAnnotationClass;
        try {
            eventHandlerAnnotationClass = (Class)_Casts.uncheckedCast(ClassUtil.forName(name));
        }
        catch (Exception ignore) {
            eventHandlerAnnotationClass = null;
        }
        return eventHandlerAnnotationClass;
    }).filter(_NullSafe::isPresent).collect(Collectors.toList());

    public RemoveAnnotatedMethodsFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        this.removeIgnoredMethods(processClassContext.getCls(), processClassContext);
    }

    private void removeIgnoredMethods(Class<?> cls, MethodRemover methodRemover) {
        Method[] methods;
        if (cls == null) {
            return;
        }
        for (Method method : methods = cls.getMethods()) {
            RemoveAnnotatedMethodsFacetFactory.removeAnnotatedMethods(methodRemover, method, PreDestroy.class);
            RemoveAnnotatedMethodsFacetFactory.removeAnnotatedMethods(methodRemover, method, PostConstruct.class);
            RemoveAnnotatedMethodsFacetFactory.removeAnnotatedMethods(methodRemover, method, Programmatic.class);
            this.eventHandlerClasses.forEach(eventHandlerClass -> RemoveAnnotatedMethodsFacetFactory.removeAnnotatedMethods(methodRemover, method, eventHandlerClass));
        }
    }

    private static <T extends Annotation> void removeAnnotatedMethods(MethodRemover methodRemover, Method method, Class<T> annotationClass) {
        if (!Annotations.isAnnotationPresent(method, annotationClass)) {
            return;
        }
        methodRemover.removeMethod(method);
    }
}

