/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.hidden.method;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.isis.applib.services.wrapper.events.VisibilityEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facets.object.hidden.HiddenObjectFacetAbstract;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.spec.ManagedObject;

public class HiddenObjectFacetViaMethod
extends HiddenObjectFacetAbstract {
    private final Method method;

    public HiddenObjectFacetViaMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    @Override
    public String hides(VisibilityContext<? extends VisibilityEvent> ic) {
        ManagedObject toValidate = ic.getTarget();
        return toValidate != null ? this.hiddenReason(toValidate) : null;
    }

    @Override
    public String hiddenReason(ManagedObject target) {
        if (target == null) {
            return null;
        }
        Boolean isHidden = (Boolean)ObjectAdapter.InvokeUtils.invoke(this.method, target);
        return isHidden != false ? "Hidden" : null;
    }

    @Override
    public void copyOnto(FacetHolder holder) {
        HiddenObjectFacetViaMethod clonedFacet = new HiddenObjectFacetViaMethod(this.method, holder);
        FacetUtil.addFacet(clonedFacet);
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("method", this.method);
    }
}

