/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.encodeable;

import org.apache.isis.applib.adapters.EncoderDecoder;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncoderDecoderUtil;
import org.apache.isis.core.metamodel.facets.object.encodeable.encoder.EncodableFacetUsingEncoderDecoder;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class EncodableFacetAbstract
extends FacetAbstract
implements EncodableFacet {
    private final Class<?> encoderDecoderClass;
    private final EncodableFacetUsingEncoderDecoder encodeableFacetUsingEncoderDecoder;
    private final ObjectAdapterProvider adapterProvider;
    private final ServicesInjector dependencyInjector;

    public EncodableFacetAbstract(String candidateEncoderDecoderName, Class<?> candidateEncoderDecoderClass, FacetHolder holder, ObjectAdapterProvider adapterProvider, ServicesInjector dependencyInjector) {
        super(EncodableFacet.class, holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.adapterProvider = adapterProvider;
        this.dependencyInjector = dependencyInjector;
        this.encoderDecoderClass = EncoderDecoderUtil.encoderDecoderOrNull(candidateEncoderDecoderClass, candidateEncoderDecoderName);
        if (this.isValid()) {
            EncoderDecoder encoderDecoder = (EncoderDecoder)ClassExtensions.newInstance(this.encoderDecoderClass, FacetHolder.class, holder);
            this.encodeableFacetUsingEncoderDecoder = new EncodableFacetUsingEncoderDecoder(encoderDecoder, holder, this.getObjectAdapterProvider(), this.getDependencyInjector());
        } else {
            this.encodeableFacetUsingEncoderDecoder = null;
        }
    }

    public boolean isValid() {
        return this.encoderDecoderClass != null;
    }

    public Class<?> getEncoderDecoderClass() {
        return this.encoderDecoderClass;
    }

    @Override
    protected String toStringValues() {
        return this.encoderDecoderClass.getName();
    }

    @Override
    public ObjectAdapter fromEncodedString(String encodedData) {
        return this.encodeableFacetUsingEncoderDecoder.fromEncodedString(encodedData);
    }

    @Override
    public String toEncodedString(ObjectAdapter object) {
        return this.encodeableFacetUsingEncoderDecoder.toEncodedString(object);
    }

    public ObjectAdapterProvider getObjectAdapterProvider() {
        return this.adapterProvider;
    }

    public ServicesInjector getDependencyInjector() {
        return this.dependencyInjector;
    }
}

