/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainservicelayout;

import java.util.List;
import java.util.Objects;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.domainservice.DomainServiceMenuOrder;
import org.apache.isis.core.metamodel.facets.object.domainservicelayout.NamedFacetForDomainServiceLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainservicelayout.annotation.DomainServiceLayoutFacetAnnotation;

public class DomainServiceLayoutFacetFactory
extends FacetFactoryAbstract {
    public DomainServiceLayoutFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        DomainService domainService = Annotations.getAnnotation(cls, DomainService.class);
        List<DomainServiceLayout> domainServiceLayouts = Annotations.getAnnotations(cls, DomainServiceLayout.class);
        if (domainService == null && domainServiceLayouts.isEmpty()) {
            return;
        }
        String domainServiceMenuOrder = domainService != null && !domainService.menuOrder().equals("2147483547") ? domainService.menuOrder() : null;
        String domainServiceLayoutMenuOrder = domainServiceLayouts.stream().map(DomainServiceLayout::menuOrder).filter(menuOrder -> !menuOrder.equals("2147483547")).findFirst().orElse(null);
        String menuOrder2 = DomainServiceMenuOrder.minimumOf(domainServiceLayoutMenuOrder, domainServiceMenuOrder);
        DomainServiceLayout.MenuBar menuBar = domainServiceLayouts.stream().map(DomainServiceLayout::menuBar).filter(mb -> mb != DomainServiceLayout.MenuBar.NOT_SPECIFIED).findFirst().orElse(DomainServiceLayout.MenuBar.PRIMARY);
        FacetUtil.addFacet(new DomainServiceLayoutFacetAnnotation((FacetHolder)facetHolder, menuBar, menuOrder2));
        String named = domainServiceLayouts.stream().map(DomainServiceLayout::named).map(_Strings::emptyToNull).filter(Objects::nonNull).findFirst().orElse(null);
        FacetUtil.addFacet(NamedFacetForDomainServiceLayoutAnnotation.create(named, facetHolder));
    }
}

