/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobjectlayout;

import java.util.List;
import java.util.Map;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.events.ui.TitleUiEvent;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacetAbstract;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.util.EventUtil;

public class TitleFacetViaDomainObjectLayoutAnnotationUsingTitleUiEvent
extends TitleFacetAbstract {
    private final Class<? extends TitleUiEvent<?>> titleUiEventClass;
    private final TranslationService translationService;
    private final String translationContext;
    private final EventBusService eventBusService;

    public static Facet create(List<DomainObjectLayout> domainObjectLayouts, ServicesInjector servicesInjector, IsisConfiguration configuration, FacetHolder facetHolder) {
        return domainObjectLayouts.stream().map(DomainObjectLayout::titleUiEvent).filter(titleUiEvent -> EventUtil.eventTypeIsPostable(titleUiEvent, TitleUiEvent.Noop.class, TitleUiEvent.Default.class, "isis.reflector.facet.domainObjectLayoutAnnotation.titleUiEvent.postForDefault", configuration)).findFirst().map(titleUiEventClass -> {
            String translationContext;
            TranslationService translationService = servicesInjector.lookupService(TranslationService.class).orElse(null);
            if (facetHolder instanceof ObjectSpecification) {
                ObjectSpecification facetHolderAsSpec = (ObjectSpecification)facetHolder;
                translationContext = facetHolderAsSpec.getCorrespondingClass().getCanonicalName();
            } else {
                translationContext = null;
            }
            EventBusService eventBusService = (EventBusService)servicesInjector.lookupServiceElseFail(EventBusService.class);
            return new TitleFacetViaDomainObjectLayoutAnnotationUsingTitleUiEvent((Class<? extends TitleUiEvent<?>>)titleUiEventClass, translationService, translationContext, eventBusService, facetHolder);
        }).orElse(null);
    }

    public TitleFacetViaDomainObjectLayoutAnnotationUsingTitleUiEvent(Class<? extends TitleUiEvent<?>> titleUiEventClass, TranslationService translationService, String translationContext, EventBusService eventBusService, FacetHolder holder) {
        super(holder);
        this.titleUiEventClass = titleUiEventClass;
        this.translationService = translationService;
        this.translationContext = translationContext;
        this.eventBusService = eventBusService;
    }

    @Override
    public String title(ManagedObject owningAdapter) {
        Facet underlyingFacet;
        if (owningAdapter == null) {
            return null;
        }
        TitleUiEvent<Object> titleUiEvent = this.newTitleUiEvent(owningAdapter);
        this.eventBusService.post(titleUiEvent);
        TranslatableString translatedTitle = titleUiEvent.getTranslatableTitle();
        if (translatedTitle != null) {
            return translatedTitle.translate(this.translationService, this.translationContext);
        }
        String title = titleUiEvent.getTitle();
        if (title == null && (underlyingFacet = this.getUnderlyingFacet()) instanceof TitleFacet) {
            TitleFacet underlyingTitleFacet = (TitleFacet)underlyingFacet;
            return underlyingTitleFacet.title(owningAdapter);
        }
        return title;
    }

    private TitleUiEvent<Object> newTitleUiEvent(ManagedObject owningAdapter) {
        Object domainObject = owningAdapter.getPojo();
        return this.newTitleUiEvent(domainObject);
    }

    private TitleUiEvent<Object> newTitleUiEvent(Object domainObject) {
        try {
            TitleUiEvent titleUiEvent = (TitleUiEvent)_Casts.uncheckedCast(this.titleUiEventClass.newInstance());
            titleUiEvent.setSource(domainObject);
            return titleUiEvent;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new NonRecoverableException((Throwable)ex);
        }
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("titleUiEventClass", this.titleUiEventClass);
    }
}

