/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobjectlayout;

import java.util.List;
import java.util.Map;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.ViewModelLayout;
import org.apache.isis.applib.events.ui.IconUiEvent;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.icon.IconFacet;
import org.apache.isis.core.metamodel.facets.object.icon.IconFacetAbstract;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.util.EventUtil;

public class IconFacetViaViewModelLayoutAnnotationUsingIconUiEvent
extends IconFacetAbstract {
    private final Class<? extends IconUiEvent<?>> iconUiEventClass;
    private final EventBusService eventBusService;

    public static Facet create(List<ViewModelLayout> viewModelLayouts, ServicesInjector servicesInjector, IsisConfiguration configuration, FacetHolder facetHolder) {
        return viewModelLayouts.stream().map(ViewModelLayout::iconUiEvent).filter(iconUiEvent -> EventUtil.eventTypeIsPostable(iconUiEvent, IconUiEvent.Noop.class, IconUiEvent.Default.class, "isis.reflector.facet.viewModelLayoutAnnotation.iconUiEvent.postForDefault", configuration)).findFirst().map(iconUiEvent -> {
            EventBusService eventBusService = (EventBusService)servicesInjector.lookupServiceElseFail(EventBusService.class);
            return new IconFacetViaViewModelLayoutAnnotationUsingIconUiEvent((Class<? extends IconUiEvent<?>>)iconUiEvent, eventBusService, facetHolder);
        }).orElse(null);
    }

    public IconFacetViaViewModelLayoutAnnotationUsingIconUiEvent(Class<? extends IconUiEvent<?>> iconUiEventClass, EventBusService eventBusService, FacetHolder holder) {
        super(holder);
        this.iconUiEventClass = iconUiEventClass;
        this.eventBusService = eventBusService;
    }

    @Override
    public String iconName(ManagedObject owningAdapter) {
        Facet underlyingFacet;
        if (owningAdapter == null) {
            return null;
        }
        IconUiEvent<Object> iconUiEvent = this.newIconUiEvent(owningAdapter);
        this.eventBusService.post(iconUiEvent);
        String iconName = iconUiEvent.getIconName();
        if (iconName == null && (underlyingFacet = this.getUnderlyingFacet()) instanceof IconFacet) {
            IconFacet underlyingIconFacet = (IconFacet)underlyingFacet;
            return underlyingIconFacet.iconName(owningAdapter);
        }
        return iconName;
    }

    private IconUiEvent<Object> newIconUiEvent(ManagedObject owningAdapter) {
        Object domainObject = owningAdapter.getPojo();
        return this.newIconUiEventForPojo(domainObject);
    }

    private IconUiEvent<Object> newIconUiEventForPojo(Object domainObject) {
        try {
            IconUiEvent iconUiEvent = (IconUiEvent)_Casts.uncheckedCast(this.iconUiEventClass.newInstance());
            iconUiEvent.setSource(domainObject);
            return iconUiEvent;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new NonRecoverableException((Throwable)ex);
        }
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("iconUiEventClass", this.iconUiEventClass);
    }
}

