/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobject.publishing;

import java.util.List;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.domainobject.publishing.PublishObjectsConfiguration;
import org.apache.isis.core.metamodel.facets.object.domainobject.publishing.PublishedObjectFacetForDomainObjectAnnotationAsConfigured;
import org.apache.isis.core.metamodel.facets.object.domainobject.publishing.PublishedObjectFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.object.publishedobject.PublishedObjectFacet;
import org.apache.isis.core.metamodel.facets.object.publishedobject.PublishedObjectFacetAbstract;

public class PublishedObjectFacetForDomainObjectAnnotation
extends PublishedObjectFacetAbstract {
    public static PublishedObjectFacet create(List<DomainObject> domainObjects, IsisConfiguration configuration, FacetHolder holder) {
        PublishObjectsConfiguration setting = PublishObjectsConfiguration.parse(configuration);
        return domainObjects.stream().map(DomainObject::publishing).filter(publishing -> publishing != Publishing.NOT_SPECIFIED).findFirst().map(publishing -> {
            switch (publishing) {
                case AS_CONFIGURED: {
                    return setting == PublishObjectsConfiguration.NONE ? null : new PublishedObjectFacetForDomainObjectAnnotationAsConfigured(holder);
                }
                case DISABLED: {
                    return null;
                }
                case ENABLED: {
                    return new PublishedObjectFacetForDomainObjectAnnotation(holder);
                }
                case NOT_SPECIFIED: {
                    throw _Exceptions.unexpectedCodeReach();
                }
            }
            throw new IllegalStateException("domainObject.publishing() not recognised, is " + publishing);
        }).orElseGet(() -> setting == PublishObjectsConfiguration.NONE ? null : new PublishedObjectFacetFromConfiguration(holder));
    }

    PublishedObjectFacetForDomainObjectAnnotation(FacetHolder holder) {
        super(holder);
    }
}

