/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobject.editing;

import java.util.List;
import java.util.Map;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.Editing;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facets.object.domainobject.editing.EditingObjectsConfiguration;
import org.apache.isis.core.metamodel.facets.object.domainobject.editing.ImmutableFacetForDomainObjectAnnotationAsConfigured;
import org.apache.isis.core.metamodel.facets.object.domainobject.editing.ImmutableFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacet;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacetAbstract;
import org.apache.isis.core.metamodel.spec.ManagedObject;

public class ImmutableFacetForDomainObjectAnnotation
extends ImmutableFacetAbstract {
    private final String reason;

    public static ImmutableFacet create(List<DomainObject> domainObjects, IsisConfiguration configuration, FacetHolder holder) {
        EditingObjectsConfiguration setting = EditingObjectsConfiguration.parse(configuration);
        return domainObjects.stream().filter(domainObject -> domainObject.editing() != Editing.NOT_SPECIFIED).findFirst().map(domainObject -> {
            String disabledReason = domainObject.editingDisabledReason();
            switch (domainObject.editing()) {
                case AS_CONFIGURED: {
                    if (holder.containsDoOpFacet(ImmutableFacet.class)) {
                        return null;
                    }
                    return setting == EditingObjectsConfiguration.FALSE ? new ImmutableFacetForDomainObjectAnnotationAsConfigured(disabledReason, holder) : null;
                }
                case DISABLED: {
                    return new ImmutableFacetForDomainObjectAnnotation(disabledReason, holder);
                }
                case ENABLED: {
                    return null;
                }
            }
            throw new IllegalStateException("domainObject.editing() not recognised, is " + domainObject.editing());
        }).orElseGet(() -> setting == EditingObjectsConfiguration.FALSE ? new ImmutableFacetFromConfiguration("Disabled", holder) : null);
    }

    public ImmutableFacetForDomainObjectAnnotation(String reason, FacetHolder holder) {
        super(holder);
        this.reason = reason;
    }

    @Override
    public String disabledReason(ManagedObject targetAdapter) {
        return !_Strings.isNullOrEmpty((CharSequence)this.reason) ? this.reason : super.disabledReason(targetAdapter);
    }

    @Override
    public void copyOnto(FacetHolder holder) {
        ImmutableFacetForDomainObjectAnnotation facet = new ImmutableFacetForDomainObjectAnnotation(this.reason, holder);
        FacetUtil.addFacet(facet);
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("reason", this.reason);
    }
}

