/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobject;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.Nature;
import org.apache.isis.applib.events.domain.ActionDomainEvent;
import org.apache.isis.applib.events.domain.CollectionDomainEvent;
import org.apache.isis.applib.events.domain.PropertyDomainEvent;
import org.apache.isis.applib.events.lifecycle.ObjectCreatedEvent;
import org.apache.isis.applib.events.lifecycle.ObjectLoadedEvent;
import org.apache.isis.applib.events.lifecycle.ObjectPersistedEvent;
import org.apache.isis.applib.events.lifecycle.ObjectPersistingEvent;
import org.apache.isis.applib.events.lifecycle.ObjectRemovingEvent;
import org.apache.isis.applib.events.lifecycle.ObjectUpdatedEvent;
import org.apache.isis.applib.events.lifecycle.ObjectUpdatingEvent;
import org.apache.isis.applib.services.HasUniqueId;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.ObjectSpecIdFacetFactory;
import org.apache.isis.core.metamodel.facets.PostConstructMethodCache;
import org.apache.isis.core.metamodel.facets.object.audit.AuditableFacet;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.callbacks.CreatedLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.callbacks.LoadedLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatedLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatingLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.auditing.AuditableFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.autocomplete.AutoCompleteFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.choices.ChoicesFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.domainevents.ActionDomainEventDefaultFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.domainevents.CollectionDomainEventDefaultFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.domainevents.PropertyDomainEventDefaultFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.editing.ImmutableFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.objectspecid.ObjectSpecIdFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.objectspecid.ObjectSpecIdFacetForJdoPersistenceCapableAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.publishing.PublishedObjectFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.recreatable.RecreatableObjectFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacet;
import org.apache.isis.core.metamodel.facets.object.mixin.MetaModelValidatorForMixinTypes;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacet;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.facets.object.publishedobject.PublishedObjectFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForValidationFailures;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.core.metamodel.util.EventUtil;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;

public class DomainObjectAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner,
PostConstructMethodCache,
ObjectSpecIdFacetFactory {
    private final MetaModelValidatorForValidationFailures autoCompleteMethodInvalid = new MetaModelValidatorForValidationFailures();
    private final MetaModelValidatorForMixinTypes mixinTypeValidator = new MetaModelValidatorForMixinTypes("@DomainObject#nature=MIXIN");
    private final Map<Class<?>, Optional<Method>> postConstructMethods = _Maps.newHashMap();
    PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    public DomainObjectAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(ObjectSpecIdFacetFactory.ProcessObjectSpecIdContext processClassContext) {
        this.processObjectType(processClassContext);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        this.processAuditing(processClassContext);
        this.processPublishing(processClassContext);
        this.processAutoComplete(processClassContext);
        this.processBounded(processClassContext);
        this.processEditing(processClassContext);
        this.processNature(processClassContext);
        this.processLifecycleEvents(processClassContext);
        this.processDomainEvents(processClassContext);
    }

    void processAuditing(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        List<DomainObject> domainObjects = Annotations.getAnnotations(cls, DomainObject.class);
        Object holder = processClassContext.getFacetHolder();
        if (HasUniqueId.class.isAssignableFrom(cls)) {
            return;
        }
        AuditableFacet auditableFacet = AuditableFacetForDomainObjectAnnotation.create(domainObjects, this.getConfiguration(), holder);
        FacetUtil.addFacet(auditableFacet);
    }

    void processPublishing(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        List<DomainObject> domainObjects = Annotations.getAnnotations(cls, DomainObject.class);
        Object facetHolder = processClassContext.getFacetHolder();
        if (HasUniqueId.class.isAssignableFrom(cls)) {
            return;
        }
        PublishedObjectFacet publishedObjectFacet = PublishedObjectFacetForDomainObjectAnnotation.create(domainObjects, this.getConfiguration(), facetHolder);
        FacetUtil.addFacet(publishedObjectFacet);
    }

    void processAutoComplete(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        List<DomainObject> domainObjects = Annotations.getAnnotations(cls, DomainObject.class);
        AutoCompleteFacet facet = this.createFor(domainObjects, (FacetHolder)facetHolder, cls);
        FacetUtil.addFacet(facet);
    }

    private AutoCompleteFacet createFor(List<DomainObject> domainObjects, FacetHolder facetHolder, Class<?> cls) {
        class Annot {
            Class<?> autoCompleteRepository;
            String autoCompleteAction;
            Method repositoryMethod;

            Annot(DomainObject domainObject) {
                this.autoCompleteRepository = domainObject.autoCompleteRepository();
                this.autoCompleteAction = domainObject.autoCompleteAction();
            }
        }
        if (domainObjects.isEmpty()) {
            return null;
        }
        return domainObjects.stream().map(domainObject -> new Annot((DomainObject)domainObject)).filter(a -> a.autoCompleteRepository != Object.class).peek(a -> {
            a.repositoryMethod = this.findRepositoryMethod(cls, "@DomainObject", a.autoCompleteRepository, a.autoCompleteAction);
        }).filter(a -> a.repositoryMethod != null).findFirst().map(a -> new AutoCompleteFacetForDomainObjectAnnotation(facetHolder, a.autoCompleteRepository, a.repositoryMethod, this.servicesInjector)).orElse(null);
    }

    private Method findRepositoryMethod(Class<?> cls, String annotationName, Class<?> repositoryClass, String methodName) {
        Method[] methods;
        for (Method method : methods = repositoryClass.getMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals(methodName) || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].equals(String.class)) continue;
            return method;
        }
        this.autoCompleteMethodInvalid.addFailure("%s annotation on %s specifies method '%s' that does not exist in repository '%s'", annotationName, cls.getName(), methodName, repositoryClass.getName());
        return null;
    }

    void processBounded(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        List<DomainObject> domainObjects = Annotations.getAnnotations(cls, DomainObject.class);
        Object facetHolder = processClassContext.getFacetHolder();
        Facet facet = ChoicesFacetForDomainObjectAnnotation.create(domainObjects, facetHolder, this.getAuthenticationSessionProvider(), this.persistenceSessionServiceInternal);
        FacetUtil.addFacet(facet);
    }

    void processEditing(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        List<DomainObject> domainObjects = Annotations.getAnnotations(cls, DomainObject.class);
        Object facetHolder = processClassContext.getFacetHolder();
        ImmutableFacet facet = ImmutableFacetForDomainObjectAnnotation.create(domainObjects, this.getConfiguration(), facetHolder);
        FacetUtil.addFacet(facet);
    }

    void processObjectType(ObjectSpecIdFacetFactory.ProcessObjectSpecIdContext processClassContext) {
        JdoPersistenceCapableFacet jdoPersistenceCapableFacet;
        JdoPersistenceCapableFacet facetHolder;
        Class<?> cls = processClassContext.getCls();
        List<DomainObject> domainObjects = Annotations.getAnnotations(cls, DomainObject.class);
        ObjectSpecIdFacet facet = ObjectSpecIdFacetForDomainObjectAnnotation.create(domainObjects, facetHolder = processClassContext.getFacetHolder());
        if (facet == null && (jdoPersistenceCapableFacet = facetHolder.getFacet(JdoPersistenceCapableFacet.class)) != null) {
            facet = ObjectSpecIdFacetForJdoPersistenceCapableAnnotation.create(jdoPersistenceCapableFacet, facetHolder);
        }
        FacetUtil.addFacet(facet);
    }

    void processNature(FacetFactory.ProcessClassContext processClassContext) {
        DomainObjectAnnotationFacetFactory postConstructMethodCache;
        Class<?> cls = processClassContext.getCls();
        List<DomainObject> domainObjects = Annotations.getAnnotations(cls, DomainObject.class);
        if (domainObjects == null) {
            return;
        }
        Object facetHolder = processClassContext.getFacetHolder();
        ViewModelFacet recreatableObjectFacet = RecreatableObjectFacetForDomainObjectAnnotation.create(domainObjects, this.persistenceSessionServiceInternal, this.servicesInjector, facetHolder, postConstructMethodCache = this);
        if (recreatableObjectFacet != null) {
            FacetUtil.addFacet(recreatableObjectFacet);
        } else {
            List<DomainObject> mixinDomainObjects = domainObjects.stream().filter(domainObject -> domainObject.nature() == Nature.MIXIN).filter(domainObject -> this.mixinTypeValidator.ensureMixinType(cls)).collect(Collectors.toList());
            MixinFacet mixinFacet = MixinFacetForDomainObjectAnnotation.create(mixinDomainObjects, cls, facetHolder, this.servicesInjector);
            FacetUtil.addFacet(mixinFacet);
        }
    }

    private void processLifecycleEvents(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        List<DomainObject> domainObjects = Annotations.getAnnotations(cls, DomainObject.class);
        if (domainObjects == null) {
            return;
        }
        Object holder = processClassContext.getFacetHolder();
        this.processLifecycleEventCreated(domainObjects, (FacetHolder)holder);
        this.processLifecycleEventLoaded(domainObjects, (FacetHolder)holder);
        this.processLifecycleEventPersisted(domainObjects, (FacetHolder)holder);
        this.processLifecycleEventPersisting(domainObjects, (FacetHolder)holder);
        this.processLifecycleEventRemoving(domainObjects, (FacetHolder)holder);
        this.processLifecycleEventUpdated(domainObjects, (FacetHolder)holder);
        this.processLifecycleEventUpdating(domainObjects, (FacetHolder)holder);
    }

    private void processDomainEvents(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        List<DomainObject> domainObjects = Annotations.getAnnotations(cls, DomainObject.class);
        if (domainObjects == null) {
            return;
        }
        Object holder = processClassContext.getFacetHolder();
        this.processDomainEventAction(domainObjects, (FacetHolder)holder);
        this.processDomainEventProperty(domainObjects, (FacetHolder)holder);
        this.processDomainEventCollection(domainObjects, (FacetHolder)holder);
    }

    private void processLifecycleEventCreated(List<DomainObject> domainObjects, FacetHolder holder) {
        domainObjects.stream().map(DomainObject::createdLifecycleEvent).filter(lifecycleEvent -> EventUtil.eventTypeIsPostable(lifecycleEvent, ObjectCreatedEvent.Noop.class, ObjectCreatedEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.createdLifecycleEvent.postForDefault", this.getConfiguration())).findFirst().map(lifecycleEvent -> new CreatedLifecycleEventFacetForDomainObjectAnnotation(holder, (Class<? extends ObjectCreatedEvent<?>>)lifecycleEvent, this.getSpecificationLoader())).ifPresent(FacetUtil::addFacet);
    }

    private void processLifecycleEventLoaded(List<DomainObject> domainObjects, FacetHolder holder) {
        domainObjects.stream().map(DomainObject::loadedLifecycleEvent).filter(lifecycleEvent -> EventUtil.eventTypeIsPostable(lifecycleEvent, ObjectLoadedEvent.Noop.class, ObjectLoadedEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.loadedLifecycleEvent.postForDefault", this.getConfiguration())).findFirst().map(lifecycleEvent -> new LoadedLifecycleEventFacetForDomainObjectAnnotation(holder, (Class<? extends ObjectLoadedEvent<?>>)lifecycleEvent, this.getSpecificationLoader())).ifPresent(FacetUtil::addFacet);
    }

    private void processLifecycleEventPersisting(List<DomainObject> domainObjects, FacetHolder holder) {
        domainObjects.stream().map(DomainObject::persistingLifecycleEvent).filter(lifecycleEvent -> EventUtil.eventTypeIsPostable(lifecycleEvent, ObjectPersistingEvent.Noop.class, ObjectPersistingEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.persistingLifecycleEvent.postForDefault", this.getConfiguration())).findFirst().map(lifecycleEvent -> new PersistingLifecycleEventFacetForDomainObjectAnnotation(holder, (Class<? extends ObjectPersistingEvent<?>>)lifecycleEvent, this.getSpecificationLoader())).ifPresent(FacetUtil::addFacet);
    }

    private void processLifecycleEventPersisted(List<DomainObject> domainObjects, FacetHolder holder) {
        domainObjects.stream().map(DomainObject::persistedLifecycleEvent).filter(lifecycleEvent -> EventUtil.eventTypeIsPostable(lifecycleEvent, ObjectPersistedEvent.Noop.class, ObjectPersistedEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.persistedLifecycleEvent.postForDefault", this.getConfiguration())).findFirst().map(lifecycleEvent -> new PersistedLifecycleEventFacetForDomainObjectAnnotation(holder, (Class<? extends ObjectPersistedEvent<?>>)lifecycleEvent, this.getSpecificationLoader())).ifPresent(FacetUtil::addFacet);
    }

    private void processLifecycleEventRemoving(List<DomainObject> domainObjects, FacetHolder holder) {
        domainObjects.stream().map(DomainObject::removingLifecycleEvent).filter(lifecycleEvent -> EventUtil.eventTypeIsPostable(lifecycleEvent, ObjectRemovingEvent.Noop.class, ObjectRemovingEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.removingLifecycleEvent.postForDefault", this.getConfiguration())).findFirst().map(lifecycleEvent -> new RemovingLifecycleEventFacetForDomainObjectAnnotation(holder, (Class<? extends ObjectRemovingEvent<?>>)lifecycleEvent, this.getSpecificationLoader())).ifPresent(FacetUtil::addFacet);
    }

    private void processLifecycleEventUpdated(List<DomainObject> domainObjects, FacetHolder holder) {
        domainObjects.stream().map(DomainObject::updatedLifecycleEvent).filter(lifecycleEvent -> EventUtil.eventTypeIsPostable(lifecycleEvent, ObjectUpdatedEvent.Noop.class, ObjectUpdatedEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.updatedLifecycleEvent.postForDefault", this.getConfiguration())).findFirst().map(lifecycleEvent -> new UpdatedLifecycleEventFacetForDomainObjectAnnotation(holder, (Class<? extends ObjectUpdatedEvent<?>>)lifecycleEvent, this.getSpecificationLoader())).ifPresent(FacetUtil::addFacet);
    }

    private void processLifecycleEventUpdating(List<DomainObject> domainObjects, FacetHolder holder) {
        domainObjects.stream().map(DomainObject::updatingLifecycleEvent).filter(lifecycleEvent -> EventUtil.eventTypeIsPostable(lifecycleEvent, ObjectUpdatingEvent.Noop.class, ObjectUpdatingEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.updatingLifecycleEvent.postForDefault", this.getConfiguration())).findFirst().map(lifecycleEvent -> new UpdatingLifecycleEventFacetForDomainObjectAnnotation(holder, (Class<? extends ObjectUpdatingEvent<?>>)lifecycleEvent, this.getSpecificationLoader())).ifPresent(FacetUtil::addFacet);
    }

    private void processDomainEventAction(List<DomainObject> domainObjects, FacetHolder holder) {
        domainObjects.stream().map(DomainObject::actionDomainEvent).filter(domainEvent -> domainEvent != ActionDomainEvent.Default.class).findFirst().map(domainEvent -> new ActionDomainEventDefaultFacetForDomainObjectAnnotation(holder, (Class<? extends ActionDomainEvent<?>>)domainEvent, this.getSpecificationLoader())).ifPresent(FacetUtil::addFacet);
    }

    private void processDomainEventProperty(List<DomainObject> domainObjects, FacetHolder holder) {
        domainObjects.stream().map(DomainObject::propertyDomainEvent).filter(domainEvent -> domainEvent != PropertyDomainEvent.Default.class).findFirst().map(domainEvent -> new PropertyDomainEventDefaultFacetForDomainObjectAnnotation(holder, (Class<? extends PropertyDomainEvent<?, ?>>)domainEvent, this.getSpecificationLoader())).ifPresent(FacetUtil::addFacet);
    }

    private void processDomainEventCollection(List<DomainObject> domainObjects, FacetHolder holder) {
        domainObjects.stream().map(DomainObject::collectionDomainEvent).filter(domainEvent -> domainEvent != CollectionDomainEvent.Default.class).findFirst().map(domainEvent -> new CollectionDomainEventDefaultFacetForDomainObjectAnnotation(holder, (Class<? extends CollectionDomainEvent<?, ?>>)domainEvent, this.getSpecificationLoader())).ifPresent(FacetUtil::addFacet);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification thisSpec, ValidationFailures validationFailures) {
                this.validate(thisSpec, validationFailures);
                return true;
            }

            private void validate(ObjectSpecification thisSpec, ValidationFailures validationFailures) {
                if (!thisSpec.isPersistenceCapableOrViewModel()) {
                    return;
                }
                HashMap specById = _Maps.newHashMap();
                for (ObjectSpecification otherSpec : DomainObjectAnnotationFacetFactory.this.getSpecificationLoader().allSpecifications()) {
                    ObjectSpecification existingSpec;
                    ObjectSpecId objectSpecId;
                    if (thisSpec == otherSpec || !otherSpec.isPersistenceCapableOrViewModel() || (objectSpecId = otherSpec.getSpecId()) == null || (existingSpec = specById.put(objectSpecId, otherSpec)) == null) continue;
                    validationFailures.add("%s: cannot have two entities with same object type (@Discriminator, @DomainObject(objectType=...), @ObjectType or @PersistenceCapable(schema=...)); %s has same value (%s).", existingSpec.getFullIdentifier(), otherSpec.getFullIdentifier(), objectSpecId);
                }
                AutoCompleteFacet autoCompleteFacet = thisSpec.getFacet(AutoCompleteFacet.class);
                if (autoCompleteFacet != null && !autoCompleteFacet.isNoop() && autoCompleteFacet instanceof AutoCompleteFacetAbstract) {
                    AutoCompleteFacetForDomainObjectAnnotation facet = (AutoCompleteFacetForDomainObjectAnnotation)autoCompleteFacet;
                    Class<?> repositoryClass = facet.getRepositoryClass();
                    boolean isService = DomainObjectAnnotationFacetFactory.this.getSpecificationLoader().isServiceClass(repositoryClass);
                    if (!isService) {
                        validationFailures.add("@DomainObject annotation on %s specifies unknown repository '%s'", thisSpec.getFullIdentifier(), repositoryClass.getName());
                    }
                }
            }
        }));
        metaModelValidator.add(this.autoCompleteMethodInvalid);
        metaModelValidator.add(this.mixinTypeValidator);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        this.persistenceSessionServiceInternal = servicesInjector.getPersistenceSessionServiceInternal();
    }

    @Override
    public Method postConstructMethodFor(Object pojo) {
        return MethodFinderUtils.findAnnotatedMethod(pojo, PostConstruct.class, this.postConstructMethods);
    }
}

