/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.choices;

import java.util.List;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.applib.services.wrapper.events.UsabilityEvent;
import org.apache.isis.applib.services.wrapper.events.ValidityEvent;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Arrays;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.objectvalue.choices.ChoicesFacet;
import org.apache.isis.core.metamodel.interactions.DisablingInteractionAdvisor;
import org.apache.isis.core.metamodel.interactions.ObjectValidityContext;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.ValidatingInteractionAdvisor;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.AuthenticationSessionProvider;

public abstract class ChoicesFacetFromBoundedAbstract
extends FacetAbstract
implements ChoicesFacet,
DisablingInteractionAdvisor,
ValidatingInteractionAdvisor {
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    public static Class<? extends Facet> type() {
        return ChoicesFacet.class;
    }

    public ChoicesFacetFromBoundedAbstract(FacetHolder holder, AuthenticationSessionProvider authenticationSessionProvider, PersistenceSessionServiceInternal persistenceSessionServiceInternal) {
        super(ChoicesFacetFromBoundedAbstract.type(), holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.authenticationSessionProvider = authenticationSessionProvider;
        this.persistenceSessionServiceInternal = persistenceSessionServiceInternal;
    }

    public PersistenceSessionServiceInternal getPersistenceSessionService() {
        return this.persistenceSessionServiceInternal;
    }

    @Override
    public String invalidates(ValidityContext<? extends ValidityEvent> context) {
        if (!(context instanceof ObjectValidityContext)) {
            return null;
        }
        ManagedObject target = context.getTarget();
        if (target == null) {
            return null;
        }
        if (!(this.getFacetHolder() instanceof ObjectSpecification)) {
            return null;
        }
        ObjectSpecification objectSpec = this.getObjectSpecification();
        return objectSpec == target.getSpecification() ? null : "Invalid type";
    }

    private ObjectSpecification getObjectSpecification() {
        return (ObjectSpecification)this.getFacetHolder();
    }

    @Override
    public String disables(UsabilityContext<? extends UsabilityEvent> context) {
        ManagedObject target = context.getTarget();
        return this.disabledReason(target);
    }

    public String disabledReason(ManagedObject inObject) {
        return "Bounded";
    }

    @Override
    public Object[] getChoices(ObjectAdapter adapter, InteractionInitiatedBy interactionInitiatedBy) {
        QueryFindAllInstances query = new QueryFindAllInstances(this.getObjectSpecification().getFullIdentifier(), new long[0]);
        List<ObjectAdapter> allInstancesAdapter = this.getPersistenceSessionService().allMatchingQuery(query);
        List<ObjectAdapter> adapters = ObjectAdapter.Util.visibleAdapters(allInstancesAdapter, interactionInitiatedBy);
        return (Object[])_NullSafe.stream(adapters).map(ObjectAdapter.Util::unwrapPojo).collect(_Arrays.toArray(Object.class, (int)_NullSafe.size(adapters)));
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.authenticationSessionProvider.getAuthenticationSession();
    }
}

