/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.callbacks;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.lang.Wormhole;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatingCallbackFacetAbstract;
import org.apache.isis.core.metamodel.spec.ManagedObject;

public class UpdatingCallbackFacetViaMethod
extends UpdatingCallbackFacetAbstract
implements ImperativeFacet {
    private final List<Method> methods = _Lists.newArrayList();

    public UpdatingCallbackFacetViaMethod(Method method, FacetHolder holder) {
        super(holder);
        this.addMethod(method);
    }

    @Override
    public void addMethod(Method method) {
        this.methods.add(method);
    }

    @Override
    public List<Method> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.LIFECYCLE;
    }

    @Override
    public void invoke(ManagedObject adapter) {
        Wormhole.invoke(() -> ObjectAdapter.InvokeUtils.invokeAll(this.methods, adapter));
    }

    @Override
    protected String toStringValues() {
        return "methods=" + this.methods;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
    }
}

