/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.bookmarkable;

import java.util.stream.Stream;
import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.BookmarkPolicyFacet;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.BookmarkPolicyFacetFallback;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class BookmarkPolicyFacetFallbackFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    public BookmarkPolicyFacetFallbackFactory() {
        super(FeatureType.OBJECTS_AND_ACTIONS);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        FacetUtil.addFacet(new BookmarkPolicyFacetFallback((FacetHolder)processClassContext.getFacetHolder()));
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetUtil.addFacet(new BookmarkPolicyFacetFallback((FacetHolder)processMethodContext.getFacetHolder()));
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                Stream<ObjectAction> objectActions = objectSpec.streamObjectActions(Contributed.EXCLUDED);
                objectActions.filter(objectAction -> {
                    BookmarkPolicyFacet bookmarkFacet = objectAction.getFacet(BookmarkPolicyFacet.class);
                    return bookmarkFacet != null && !bookmarkFacet.isNoop() && bookmarkFacet.value() != BookmarkPolicy.NEVER;
                }).forEach(objectAction -> {
                    ActionSemanticsFacet semanticsFacet = objectAction.getFacet(ActionSemanticsFacet.class);
                    if (semanticsFacet == null || semanticsFacet.isNoop() || !((SemanticsOf)semanticsFacet.value()).isSafeInNature()) {
                        validationFailures.add("%s: action is bookmarkable but action semantics are not explicitly indicated as being safe.  Either add @Action(semantics=SemanticsOf.SAFE) or @Action(semantics=SemanticsOf.SAFE_AND_REQUEST_CACHEABLE), or remove @ActionLayout(bookmarking=...).", objectAction.getIdentifier().toClassAndNameIdentityString());
                    }
                });
                return true;
            }
        }));
    }
}

