/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object;

import org.apache.isis.applib.RecreatableDomainObject;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.Nature;
import org.apache.isis.applib.annotation.ViewModel;
import org.apache.isis.applib.annotation.ViewModelLayout;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForValidationFailures;

public class ViewModelSemanticCheckingFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    private final MetaModelValidatorForValidationFailures validator = new MetaModelValidatorForValidationFailures();

    public ViewModelSemanticCheckingFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        boolean annotatedWithViewModel;
        boolean enable = this.getConfiguration().getBoolean("isis.reflector.facets.ViewModelSemanticCheckingFacetFactory.enable", false);
        if (!enable) {
            return;
        }
        Class<?> cls = processClassContext.getCls();
        DomainObjectLayout domainObjectLayout = Annotations.getAnnotation(cls, DomainObjectLayout.class);
        ViewModelLayout viewModelLayout = Annotations.getAnnotation(cls, ViewModelLayout.class);
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        ViewModel viewModel = Annotations.getAnnotation(cls, ViewModel.class);
        boolean implementsViewModel = org.apache.isis.applib.ViewModel.class.isAssignableFrom(cls);
        boolean implementsRecreatableDomainObject = RecreatableDomainObject.class.isAssignableFrom(cls);
        boolean annotatedWithDomainObjectLayout = domainObjectLayout != null;
        boolean annotatedWithViewModelLayout = viewModelLayout != null;
        boolean annotatedWithDomainObject = domainObject != null;
        boolean bl = annotatedWithViewModel = viewModel != null;
        if (implementsViewModel && implementsRecreatableDomainObject) {
            this.validator.addFailure("Inconsistent view model / domain object semantics; %s should not implement both %s and %s interfaces (implement one or the other)", cls.getName(), org.apache.isis.applib.ViewModel.class.getSimpleName(), RecreatableDomainObject.class.getSimpleName());
        }
        if (implementsViewModel && annotatedWithDomainObject) {
            this.validator.addFailure("Inconsistent view model / domain object semantics; %1$s should not implement %2$s and be annotated with @%3$s (annotate with %4$s instead of %2$s, or implement %5s instead of %2$s)", cls.getName(), org.apache.isis.applib.ViewModel.class.getSimpleName(), DomainObject.class.getSimpleName(), ViewModel.class.getSimpleName(), RecreatableDomainObject.class.getSimpleName());
        }
        if (implementsViewModel && annotatedWithDomainObjectLayout) {
            this.validator.addFailure("Inconsistent view model / domain object semantics; %1$s should not implement %2$s and be annotated with @%3$s (annotate with @%4$s instead of %3$s, or implement %5$s instead of %2$s)", cls.getName(), org.apache.isis.applib.ViewModel.class.getSimpleName(), DomainObjectLayout.class.getSimpleName(), ViewModelLayout.class.getSimpleName(), RecreatableDomainObject.class.getSimpleName());
        }
        if (annotatedWithViewModel && implementsRecreatableDomainObject) {
            this.validator.addFailure("Inconsistent view model / domain object semantics; %1$s should not be annotated with @%2$s but implement @%3$s (implement %4$s instead of %3$s, or annotate with @%5$s with nature of %6s, %7s or %8s instead of annotating with @%2$s)", cls.getName(), ViewModel.class.getSimpleName(), RecreatableDomainObject.class.getSimpleName(), org.apache.isis.applib.ViewModel.class.getName(), DomainObject.class.getName(), Nature.VIEW_MODEL, Nature.INMEMORY_ENTITY, Nature.EXTERNAL_ENTITY);
        }
        if (annotatedWithViewModel && annotatedWithDomainObject) {
            this.validator.addFailure("Inconsistent view model / domain object semantics; %1$s should not be annotated with both @%2$s and @%3$s (annotate with one or the other)", cls.getName(), ViewModel.class.getSimpleName(), DomainObject.class.getSimpleName());
        }
        if (annotatedWithViewModel && annotatedWithDomainObjectLayout) {
            this.validator.addFailure("Inconsistent view model / domain object semantics; %1$s should not be annotated with both @%2$s and @%3$s (annotate with @%4$s instead of @%3$s, or annotate with @%5$s instead of @%2$s)", cls.getName(), ViewModel.class.getSimpleName(), DomainObjectLayout.class.getSimpleName(), ViewModelLayout.class.getSimpleName(), DomainObject.class.getSimpleName());
        }
        if (annotatedWithViewModelLayout && implementsRecreatableDomainObject) {
            this.validator.addFailure("Inconsistent view model / domain object semantics; %1$s should not be annotated with @%2$s but implement @%3$s (implement %4$s instead of %3$s, or annotate with %5$s instead of %2$s)", cls.getName(), ViewModelLayout.class.getSimpleName(), RecreatableDomainObject.class.getSimpleName(), org.apache.isis.applib.ViewModel.class.getSimpleName(), DomainObjectLayout.class.getSimpleName());
        }
        if (annotatedWithViewModelLayout && annotatedWithDomainObject) {
            this.validator.addFailure("Inconsistent view model / domain object semantics; %1$s should not be annotated with @%2$s and also be annotated with @%3$s (annotate with @%4$s instead of @%3$s, or instead annotate with @%5$s instead of @%2$s)", cls.getName(), ViewModelLayout.class.getSimpleName(), DomainObject.class.getSimpleName(), ViewModel.class.getSimpleName(), DomainObjectLayout.class.getSimpleName());
        }
        if (annotatedWithViewModelLayout && annotatedWithDomainObjectLayout) {
            this.validator.addFailure("Inconsistent view model / domain object semantics; %1$s should not be annotated with both @%2$s and @%3$s (annotate with one or the other)", cls.getName(), ViewModel.class.getSimpleName(), DomainObjectLayout.class.getSimpleName(), ViewModelLayout.class.getSimpleName());
        }
        if (annotatedWithDomainObject && (domainObject.nature() == Nature.NOT_SPECIFIED || domainObject.nature() == Nature.JDO_ENTITY) && implementsRecreatableDomainObject) {
            this.validator.addFailure("Inconsistent view model / domain object semantics; %1$s should not be annotated with @%2$s with nature of %3$s and also implement %4$s (specify a nature of %5$s, %6$s or %7$s)", cls.getName(), DomainObject.class.getSimpleName(), domainObject.nature(), RecreatableDomainObject.class.getSimpleName(), Nature.EXTERNAL_ENTITY, Nature.INMEMORY_ENTITY, Nature.VIEW_MODEL);
        }
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        metaModelValidator.add(this.validator);
    }
}

