/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.order.annotprop;

import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.members.order.annotprop.MemberOrderFacetAnnotation;

public class MemberOrderFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public MemberOrderFacetFactory() {
        super(FeatureType.MEMBERS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        MemberOrderFacet memberOrderFacet = this.createFromAnnotationIfPossible(processMethodContext);
        FacetUtil.addFacet(memberOrderFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
    }

    private MemberOrderFacet createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        MemberOrder annotation = Annotations.getAnnotation(processMethodContext.getMethod(), MemberOrder.class);
        if (annotation != null) {
            return new MemberOrderFacetAnnotation(annotation.name(), annotation.sequence(), this.servicesInjector.lookupService(TranslationService.class).orElse(null), (FacetHolder)processMethodContext.getFacetHolder());
        }
        return null;
    }
}

