/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.order;

import java.util.Map;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.MultipleValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;

public abstract class MemberOrderFacetAbstract
extends MultipleValueFacetAbstract
implements MemberOrderFacet {
    private final String originalName;
    private final String name;
    private final String sequence;

    public static Class<? extends Facet> type() {
        return MemberOrderFacet.class;
    }

    public MemberOrderFacetAbstract(String name, String sequence, TranslationService translationService, FacetHolder holder) {
        this(MemberOrderFacetAbstract.translatedValueElse(name, "", translationService, holder), sequence, holder);
    }

    public MemberOrderFacetAbstract(String name, String sequence, FacetHolder holder) {
        super(MemberOrderFacetAbstract.type(), holder);
        this.name = MemberOrderFacetAbstract.valueElse(name, "");
        this.originalName = MemberOrderFacetAbstract.valueElse(name, "");
        this.sequence = MemberOrderFacetAbstract.valueElse(sequence, "1");
    }

    private static String translatedValueElse(String name, String defaultValue, TranslationService translationService, FacetHolder holder) {
        boolean nullOrEmpty = _Strings.isNullOrEmpty((CharSequence)name);
        if (nullOrEmpty) {
            return defaultValue;
        }
        IdentifiedHolder identifiedHolder = (IdentifiedHolder)holder;
        String context = identifiedHolder.getIdentifier().getClassName();
        return translationService.translate(context, name);
    }

    private static String valueElse(String name, String defaultValue) {
        boolean nullOrEmpty = _Strings.isNullOrEmpty((CharSequence)name);
        if (nullOrEmpty) {
            return defaultValue;
        }
        return name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String untranslatedName() {
        return this.originalName;
    }

    @Override
    public String sequence() {
        return this.sequence;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("name", this.name);
        attributeMap.put("originalName", this.originalName);
        attributeMap.put("sequence", this.sequence);
    }
}

