/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.hidden.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.services.wrapper.events.VisibilityEvent;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.members.hidden.method.HideForContextFacetAbstract;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.spec.ManagedObject;

public class HideForContextFacetViaMethod
extends HideForContextFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public HideForContextFacetViaMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHECK_IF_HIDDEN;
    }

    @Override
    public String hides(VisibilityContext<? extends VisibilityEvent> ic) {
        ManagedObject target = ic.getTarget();
        if (target == null) {
            return null;
        }
        Boolean isHidden = (Boolean)ObjectAdapter.InvokeUtils.invokeC(this.method, target, _NullSafe.streamNullable(ic.getContributeeWithParamIndex()));
        return isHidden != false ? "Hidden" : null;
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
    }
}

